/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.managers;

import emu.grasscutter.command.CommandMap;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.packet.send.PacketPlayerChatNotify;
import emu.grasscutter.server.packet.send.PacketPrivateChatNotify;
import java.util.Arrays;
import java.util.List;

public class ChatManager {
    static final List<Character> PREFIXES = Arrays.asList(Character.valueOf('/'), Character.valueOf('!'));
    private final GameServer server;

    public ChatManager(GameServer server) {
        this.server = server;
    }

    public GameServer getServer() {
        return this.server;
    }

    public void sendPrivateMessage(Player player, int targetUid, String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (PREFIXES.contains(Character.valueOf(message.charAt(0)))) {
            CommandMap.getInstance().invoke(player, message);
            return;
        }
        Player target = this.getServer().getPlayerByUid(targetUid);
        if (target == null) {
            return;
        }
        PacketPrivateChatNotify packet = new PacketPrivateChatNotify(player.getUid(), target.getUid(), message);
        player.sendPacket(packet);
        target.sendPacket(packet);
    }

    public void sendPrivateMessage(Player player, int targetUid, int emote) {
        Player target = this.getServer().getPlayerByUid(targetUid);
        if (target == null) {
            return;
        }
        PacketPrivateChatNotify packet = new PacketPrivateChatNotify(player.getUid(), target.getUid(), emote);
        player.sendPacket(packet);
        target.sendPacket(packet);
    }

    public void sendTeamMessage(Player player, int channel, String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (PREFIXES.contains(Character.valueOf(message.charAt(0)))) {
            CommandMap.getInstance().invoke(player, message);
            return;
        }
        player.getWorld().broadcastPacket(new PacketPlayerChatNotify(player, channel, message));
    }

    public void sendTeamMessage(Player player, int channel, int icon) {
        player.getWorld().broadcastPacket(new PacketPlayerChatNotify(player, channel, icon));
    }
}

