/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.inventory;

import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.InventoryTab;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class MaterialInventoryTab
implements InventoryTab {
    private final Int2ObjectMap<GameItem> items = new Int2ObjectOpenHashMap<GameItem>();
    private final int maxCapacity;

    public MaterialInventoryTab(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    @Override
    public GameItem getItemById(int id) {
        return (GameItem)this.items.get(id);
    }

    @Override
    public void onAddItem(GameItem item) {
        this.items.put(item.getItemId(), item);
    }

    @Override
    public void onRemoveItem(GameItem item) {
        this.items.remove(item.getItemId());
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public int getMaxCapacity() {
        return this.maxCapacity;
    }
}

