/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.inventory;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.Transient;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameDepot;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.ReliquaryAffixData;
import emu.grasscutter.data.def.ReliquaryMainPropData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.EquipOuterClass;
import emu.grasscutter.net.proto.FurnitureOuterClass;
import emu.grasscutter.net.proto.ItemHintOuterClass;
import emu.grasscutter.net.proto.ItemOuterClass;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.net.proto.MaterialOuterClass;
import emu.grasscutter.net.proto.ReliquaryOuterClass;
import emu.grasscutter.net.proto.SceneReliquaryInfoOuterClass;
import emu.grasscutter.net.proto.SceneWeaponInfoOuterClass;
import emu.grasscutter.net.proto.WeaponOuterClass;
import emu.grasscutter.utils.WeightedList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bson.types.ObjectId;

@Entity(value="items", useDiscriminator=false)
public class GameItem {
    @Id
    private ObjectId id;
    @Indexed
    private int ownerId;
    private int itemId;
    private int count;
    @Transient
    private long guid;
    @Transient
    private ItemData itemData;
    private int level;
    private int exp;
    private int totalExp;
    private int promoteLevel;
    private boolean locked;
    private List<Integer> affixes;
    private int refinement;
    private int mainPropId;
    private List<Integer> appendPropIdList;
    private int equipCharacter;
    @Transient
    private int weaponEntityId;

    public GameItem() {
        this.refinement = 0;
    }

    public GameItem(int itemId) {
        this((ItemData)GameData.getItemDataMap().get(itemId));
    }

    public GameItem(int itemId, int count) {
        this((ItemData)GameData.getItemDataMap().get(itemId), count);
    }

    public GameItem(ItemData data) {
        this(data, 1);
    }

    public GameItem(ItemData data, int count) {
        block6: {
            block5: {
                this.refinement = 0;
                this.itemId = data.getId();
                this.itemData = data;
                this.count = data.getItemType() == ItemType.ITEM_VIRTUAL ? count : Math.min(count, data.getStackLimit());
                if (this.getItemType() != ItemType.ITEM_WEAPON) break block5;
                this.level = Math.max(this.count, 1);
                this.affixes = new ArrayList<Integer>(2);
                if (this.getItemData().getSkillAffix() == null) break block6;
                for (int skillAffix : this.getItemData().getSkillAffix()) {
                    if (skillAffix <= 0) continue;
                    this.affixes.add(skillAffix);
                }
                break block6;
            }
            if (this.getItemType() == ItemType.ITEM_RELIQUARY) {
                this.level = 1;
                this.appendPropIdList = new ArrayList<Integer>();
                ReliquaryMainPropData mainPropData = GameDepot.getRandomRelicMainProp(this.getItemData().getMainPropDepotId());
                if (mainPropData != null) {
                    this.mainPropId = mainPropData.getId();
                }
                if (this.getItemData().getAppendPropNum() > 0) {
                    for (int i2 = 0; i2 < this.getItemData().getAppendPropNum(); ++i2) {
                        this.addAppendProp();
                    }
                }
            }
        }
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwner(Player player) {
        this.ownerId = player.getUid();
        this.guid = player.getNextGameGuid();
    }

    public int getItemId() {
        return this.itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public long getGuid() {
        return this.guid;
    }

    public ItemType getItemType() {
        return this.itemData.getItemType();
    }

    public ItemData getItemData() {
        return this.itemData;
    }

    public void setItemData(ItemData materialData) {
        this.itemData = materialData;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp2) {
        this.exp = exp2;
    }

    public int getTotalExp() {
        return this.totalExp;
    }

    public void setTotalExp(int totalExp) {
        this.totalExp = totalExp;
    }

    public int getPromoteLevel() {
        return this.promoteLevel;
    }

    public void setPromoteLevel(int promoteLevel) {
        this.promoteLevel = promoteLevel;
    }

    public int getEquipSlot() {
        return this.getItemData().getEquipType().getValue();
    }

    public int getEquipCharacter() {
        return this.equipCharacter;
    }

    public void setEquipCharacter(int equipCharacter) {
        this.equipCharacter = equipCharacter;
    }

    public boolean isEquipped() {
        return this.getEquipCharacter() > 0;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isDestroyable() {
        return !this.isLocked() && !this.isEquipped();
    }

    public int getWeaponEntityId() {
        return this.weaponEntityId;
    }

    public void setWeaponEntityId(int weaponEntityId) {
        this.weaponEntityId = weaponEntityId;
    }

    public List<Integer> getAffixes() {
        return this.affixes;
    }

    public int getRefinement() {
        return this.refinement;
    }

    public void setRefinement(int refinement) {
        this.refinement = refinement;
    }

    public int getMainPropId() {
        return this.mainPropId;
    }

    public void setMainPropId(int mainPropId) {
        this.mainPropId = mainPropId;
    }

    public List<Integer> getAppendPropIdList() {
        return this.appendPropIdList;
    }

    public void addAppendProp() {
        if (this.getAppendPropIdList() == null) {
            this.appendPropIdList = new ArrayList<Integer>();
        }
        if (this.getAppendPropIdList().size() < 4) {
            this.addNewAppendProp();
        } else {
            this.upgradeRandomAppendProp();
        }
    }

    private void addNewAppendProp() {
        Object affixData;
        List<ReliquaryAffixData> affixList = GameDepot.getRandomRelicAffixList(this.getItemData().getAppendPropDepotId());
        if (affixList == null) {
            return;
        }
        HashSet<FightProperty> blacklist = new HashSet<FightProperty>();
        ReliquaryMainPropData mainPropData = (ReliquaryMainPropData)GameData.getReliquaryMainPropDataMap().get(this.getMainPropId());
        if (mainPropData != null) {
            blacklist.add(mainPropData.getFightProp());
        }
        int len2 = Math.min(4, this.getAppendPropIdList().size());
        for (int i2 = 0; i2 < len2; ++i2) {
            affixData = (ReliquaryAffixData)GameData.getReliquaryAffixDataMap().get(this.getAppendPropIdList().get(i2));
            if (affixData == null) continue;
            blacklist.add(((ReliquaryAffixData)affixData).getFightProp());
        }
        WeightedList<ReliquaryAffixData> randomList = new WeightedList<ReliquaryAffixData>();
        for (ReliquaryAffixData affix : affixList) {
            if (blacklist.contains((Object)affix.getFightProp())) continue;
            randomList.add(affix.getWeight(), affix);
        }
        if (randomList.size() == 0) {
            return;
        }
        affixData = (ReliquaryAffixData)randomList.next();
        this.getAppendPropIdList().add(((ReliquaryAffixData)affixData).getId());
    }

    private void upgradeRandomAppendProp() {
        Object affixData;
        List<ReliquaryAffixData> affixList = GameDepot.getRandomRelicAffixList(this.getItemData().getAppendPropDepotId());
        if (affixList == null) {
            return;
        }
        HashSet<FightProperty> whitelist = new HashSet<FightProperty>();
        int len2 = Math.min(4, this.getAppendPropIdList().size());
        for (int i2 = 0; i2 < len2; ++i2) {
            affixData = (ReliquaryAffixData)GameData.getReliquaryAffixDataMap().get(this.getAppendPropIdList().get(i2));
            if (affixData == null) continue;
            whitelist.add(((ReliquaryAffixData)affixData).getFightProp());
        }
        WeightedList<ReliquaryAffixData> randomList = new WeightedList<ReliquaryAffixData>();
        for (ReliquaryAffixData affix : affixList) {
            if (!whitelist.contains((Object)affix.getFightProp())) continue;
            randomList.add(affix.getUpgradeWeight(), affix);
        }
        affixData = (ReliquaryAffixData)randomList.next();
        this.getAppendPropIdList().add(((ReliquaryAffixData)affixData).getId());
    }

    @PostLoad
    public void onLoad() {
        if (this.itemData == null) {
            this.itemData = (ItemData)GameData.getItemDataMap().get(this.getItemId());
        }
    }

    public void save() {
        if (this.count > 0 && this.ownerId > 0) {
            DatabaseHelper.saveItem(this);
        } else if (this.getObjectId() != null) {
            DatabaseHelper.deleteItem(this);
        }
    }

    public SceneWeaponInfoOuterClass.SceneWeaponInfo createSceneWeaponInfo() {
        SceneWeaponInfoOuterClass.SceneWeaponInfo.Builder weaponInfo = SceneWeaponInfoOuterClass.SceneWeaponInfo.newBuilder().setEntityId(this.getWeaponEntityId()).setItemId(this.getItemId()).setGuid(this.getGuid()).setLevel(this.getLevel()).setGadgetId(this.getItemData().getGadgetId()).setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder().setIsInited(this.getAffixes().size() > 0));
        if (this.getAffixes() != null && this.getAffixes().size() > 0) {
            for (int affix : this.getAffixes()) {
                weaponInfo.putAffixMap(affix, this.getRefinement());
            }
        }
        return weaponInfo.build();
    }

    public SceneReliquaryInfoOuterClass.SceneReliquaryInfo createSceneReliquaryInfo() {
        SceneReliquaryInfoOuterClass.SceneReliquaryInfo relicInfo = SceneReliquaryInfoOuterClass.SceneReliquaryInfo.newBuilder().setItemId(this.getItemId()).setGuid(this.getGuid()).setLevel(this.getLevel()).build();
        return relicInfo;
    }

    public WeaponOuterClass.Weapon toWeaponProto() {
        WeaponOuterClass.Weapon.Builder weapon = WeaponOuterClass.Weapon.newBuilder().setLevel(this.getLevel()).setExp(this.getExp()).setPromoteLevel(this.getPromoteLevel());
        if (this.getAffixes() != null && this.getAffixes().size() > 0) {
            for (int affix : this.getAffixes()) {
                weapon.putAffixMap(affix, this.getRefinement());
            }
        }
        return weapon.build();
    }

    public ReliquaryOuterClass.Reliquary toReliquaryProto() {
        ReliquaryOuterClass.Reliquary.Builder relic = ReliquaryOuterClass.Reliquary.newBuilder().setLevel(this.getLevel()).setExp(this.getExp()).setPromoteLevel(this.getPromoteLevel()).setMainPropId(this.getMainPropId()).addAllAppendPropIdList(this.getAppendPropIdList());
        return relic.build();
    }

    public ItemOuterClass.Item toProto() {
        ItemOuterClass.Item.Builder proto = ItemOuterClass.Item.newBuilder().setGuid(this.getGuid()).setItemId(this.getItemId());
        switch (this.getItemType()) {
            case ITEM_WEAPON: {
                WeaponOuterClass.Weapon weapon = this.toWeaponProto();
                proto.setEquip(EquipOuterClass.Equip.newBuilder().setWeapon(weapon).setIsLocked(this.isLocked()).build());
                break;
            }
            case ITEM_RELIQUARY: {
                ReliquaryOuterClass.Reliquary relic = this.toReliquaryProto();
                proto.setEquip(EquipOuterClass.Equip.newBuilder().setReliquary(relic).setIsLocked(this.isLocked()).build());
                break;
            }
            case ITEM_MATERIAL: {
                MaterialOuterClass.Material material = MaterialOuterClass.Material.newBuilder().setCount(this.getCount()).build();
                proto.setMaterial(material);
                break;
            }
            case ITEM_FURNITURE: {
                FurnitureOuterClass.Furniture furniture = FurnitureOuterClass.Furniture.newBuilder().setCount(this.getCount()).build();
                proto.setFurniture(furniture);
                break;
            }
        }
        return proto.build();
    }

    public ItemHintOuterClass.ItemHint toItemHintProto() {
        return ItemHintOuterClass.ItemHint.newBuilder().setItemId(this.getItemId()).setCount(this.getCount()).setIsNew(false).build();
    }

    public ItemParamOuterClass.ItemParam toItemParam() {
        return ItemParamOuterClass.ItemParam.newBuilder().setItemId(this.getItemId()).setCount(this.getCount()).build();
    }
}

