/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.gacha;

import com.google.gson.reflect.TypeToken;
import com.sun.nio.file.SensitivityWatchEventModifier;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.gacha.GachaBanner;
import emu.grasscutter.game.gacha.GachaRecord;
import emu.grasscutter.game.gacha.PlayerGachaBannerInfo;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.inventory.MaterialType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.proto.GachaItemOuterClass;
import emu.grasscutter.net.proto.GachaTransferItemOuterClass;
import emu.grasscutter.net.proto.GetGachaInfoRspOuterClass;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.game.GameServerTickEvent;
import emu.grasscutter.server.packet.send.PacketDoGachaRsp;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.greenrobot.eventbus.Subscribe;

public class GachaManager {
    private final GameServer server;
    private final Int2ObjectMap<GachaBanner> gachaBanners;
    private GetGachaInfoRspOuterClass.GetGachaInfoRsp cachedProto;
    WatchService watchService;
    private int[] yellowAvatars = new int[]{1003, 1016, 1042, 1035, 1041};
    private int[] yellowWeapons = new int[]{11501, 11502, 12501, 12502, 13502, 13505, 14501, 14502, 15501, 15502};
    private int[] purpleAvatars = new int[]{1006, 1014, 1015, 1020, 1021, 1023, 1024, 1025, 1027, 1031, 1032, 1034, 1036, 1039, 1043, 1044, 1045, 1048, 1053, 1055, 1056, 1064};
    private int[] purpleWeapons = new int[]{11401, 11402, 11403, 11405, 12401, 12402, 12403, 12405, 13401, 13407, 14401, 14402, 14403, 14409, 15401, 15402, 15403, 15405};
    private int[] blueWeapons = new int[]{11301, 11302, 11306, 12301, 12302, 12305, 13303, 14301, 14302, 14304, 15301, 15302, 15304};
    private static int starglitterId = 221;
    private static int stardustId = 222;

    public GachaManager(GameServer server) {
        this.server = server;
        this.gachaBanners = new Int2ObjectOpenHashMap<GachaBanner>();
        this.load();
        this.startWatcher(server);
    }

    public GameServer getServer() {
        return this.server;
    }

    public Int2ObjectMap<GachaBanner> getGachaBanners() {
        return this.gachaBanners;
    }

    public int randomRange(int min2, int max2) {
        return ThreadLocalRandom.current().nextInt(max2 - min2 + 1) + min2;
    }

    public int getRandom(int[] array) {
        return array[this.randomRange(0, array.length - 1)];
    }

    public synchronized void load() {
        try (FileReader fileReader = new FileReader(Grasscutter.getConfig().DATA_FOLDER + "Banners.json");){
            this.getGachaBanners().clear();
            List banners = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{GachaBanner.class}).getType());
            if (banners.size() > 0) {
                for (GachaBanner banner : banners) {
                    this.getGachaBanners().put(banner.getGachaType(), banner);
                }
                Grasscutter.getLogger().info("Banners successfully loaded.");
                this.cachedProto = this.createProto();
            } else {
                Grasscutter.getLogger().error("Unable to load banners. Banners size is 0.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void doPulls(Player player, int gachaType, int times) {
        if (times != 10 && times != 1) {
            return;
        }
        if (player.getInventory().getInventoryTab(ItemType.ITEM_WEAPON).getSize() + times > player.getInventory().getInventoryTab(ItemType.ITEM_WEAPON).getMaxCapacity()) {
            player.sendPacket(new PacketDoGachaRsp());
            return;
        }
        GachaBanner banner = (GachaBanner)this.getGachaBanners().get(gachaType);
        if (banner == null) {
            player.sendPacket(new PacketDoGachaRsp());
            return;
        }
        if (banner.getCostItem() > 0) {
            GameItem costItem = player.getInventory().getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(banner.getCostItem());
            if (costItem == null || costItem.getCount() < times) {
                return;
            }
            player.getInventory().removeItem(costItem, times);
        }
        PlayerGachaBannerInfo gachaInfo = player.getGachaInfo().getBannerInfo(banner);
        IntArrayList wonItems = new IntArrayList(times);
        for (int i2 = 0; i2 < times; ++i2) {
            int random2 = this.randomRange(1, 10000);
            int itemId = 0;
            int bonusYellowChance = gachaInfo.getPity5() >= banner.getSoftPity() ? 100 * (gachaInfo.getPity5() - banner.getSoftPity() - 1) : 0;
            int yellowChance = banner.getBaseYellowWeight() + (int)Math.floor(100.0 * ((double)gachaInfo.getPity5() / ((double)banner.getSoftPity() - 1.0))) + bonusYellowChance;
            int purpleChance = 10000 - (banner.getBasePurpleWeight() + (int)Math.floor(790.0f * ((float)gachaInfo.getPity4() / 8.0f)));
            if (random2 <= yellowChance || gachaInfo.getPity5() >= banner.getHardPity()) {
                if (banner.getRateUpItems1().length > 0) {
                    eventChance = this.randomRange(1, 100);
                    if (eventChance <= banner.getEventChance() || gachaInfo.getFailedFeaturedItemPulls() >= 1) {
                        itemId = this.getRandom(banner.getRateUpItems1());
                        gachaInfo.setFailedFeaturedItemPulls(0);
                    } else {
                        gachaInfo.addFailedFeaturedItemPulls(1);
                    }
                }
                if (itemId == 0) {
                    typeChance = this.randomRange(banner.getBannerType() == GachaBanner.BannerType.WEAPON ? 2 : 1, banner.getBannerType() == GachaBanner.BannerType.EVENT ? 1 : 2);
                    itemId = typeChance == 1 ? this.getRandom(this.yellowAvatars) : this.getRandom(this.yellowWeapons);
                }
                gachaInfo.addPity4(1);
                gachaInfo.setPity5(0);
            } else if (random2 >= purpleChance || gachaInfo.getPity4() >= 9) {
                if (banner.getRateUpItems2().length > 0 && (eventChance = this.randomRange(1, 100)) >= 50) {
                    itemId = this.getRandom(banner.getRateUpItems2());
                }
                if (itemId == 0) {
                    typeChance = this.randomRange(banner.getBannerType() == GachaBanner.BannerType.WEAPON ? 2 : 1, banner.getBannerType() == GachaBanner.BannerType.EVENT ? 1 : 2);
                    itemId = typeChance == 1 ? this.getRandom(this.purpleAvatars) : this.getRandom(this.purpleWeapons);
                }
                gachaInfo.addPity5(1);
                gachaInfo.setPity4(0);
            } else {
                itemId = this.getRandom(this.blueWeapons);
                gachaInfo.addPity4(1);
                gachaInfo.addPity5(1);
            }
            wonItems.add(itemId);
        }
        ArrayList<GachaItemOuterClass.GachaItem> list = new ArrayList<GachaItemOuterClass.GachaItem>();
        int stardust = 0;
        int starglitter = 0;
        IntListIterator intListIterator = wonItems.iterator();
        while (intListIterator.hasNext()) {
            int itemId = (Integer)intListIterator.next();
            ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemId);
            if (itemData == null) continue;
            GachaRecord gachaRecord = new GachaRecord(itemId, player.getUid(), gachaType);
            DatabaseHelper.saveGachaRecord(gachaRecord);
            GachaItemOuterClass.GachaItem.Builder gachaItem = GachaItemOuterClass.GachaItem.newBuilder();
            int addStardust = 0;
            int addStarglitter = 0;
            boolean isTransferItem = false;
            if (itemData.getMaterialType() == MaterialType.MATERIAL_AVATAR) {
                int avatarId = itemData.getId() % 1000 + 10000000;
                Avatar avatar = player.getAvatars().getAvatarById(avatarId);
                if (avatar != null) {
                    int constLevel = avatar.getCoreProudSkillLevel();
                    int constItemId = itemData.getId() + 100;
                    GameItem constItem = player.getInventory().getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(constItemId);
                    if (constItem != null) {
                        constLevel += constItem.getCount();
                    }
                    if (constLevel < 6) {
                        addStarglitter = 2;
                        gachaItem.addTransferItems(GachaTransferItemOuterClass.GachaTransferItem.newBuilder().setItem(ItemParamOuterClass.ItemParam.newBuilder().setItemId(constItemId).setCount(1)).setIsTransferItemNew(constItem == null));
                        player.getInventory().addItem(constItemId, 1);
                    } else {
                        addStarglitter = 5;
                    }
                    if (itemData.getRankLevel() == 5) {
                        addStarglitter *= 5;
                    }
                    isTransferItem = true;
                } else {
                    gachaItem.setIsGachaItemNew(true);
                }
            } else {
                switch (itemData.getRankLevel()) {
                    case 5: {
                        addStarglitter = 10;
                        break;
                    }
                    case 4: {
                        addStarglitter = 2;
                        break;
                    }
                    case 3: {
                        addStardust = 15;
                    }
                }
            }
            GameItem item = new GameItem(itemData);
            gachaItem.setGachaItem(item.toItemParam());
            player.getInventory().addItem(item);
            stardust += addStardust;
            starglitter += addStarglitter;
            if (addStardust > 0) {
                gachaItem.addTokenItemList(ItemParamOuterClass.ItemParam.newBuilder().setItemId(stardustId).setCount(addStardust));
            }
            if (addStarglitter > 0) {
                ItemParamOuterClass.ItemParam starglitterParam = ItemParamOuterClass.ItemParam.newBuilder().setItemId(starglitterId).setCount(addStarglitter).build();
                if (isTransferItem) {
                    gachaItem.addTransferItems(GachaTransferItemOuterClass.GachaTransferItem.newBuilder().setItem(starglitterParam));
                }
                gachaItem.addTokenItemList(starglitterParam);
            }
            list.add(gachaItem.build());
        }
        if (stardust > 0) {
            player.getInventory().addItem(stardustId, stardust);
        }
        if (starglitter > 0) {
            player.getInventory().addItem(starglitterId, starglitter);
        }
        player.sendPacket(new PacketDoGachaRsp(banner, list));
    }

    private synchronized void startWatcher(GameServer server) {
        if (this.watchService == null) {
            try {
                this.watchService = FileSystems.getDefault().newWatchService();
                Path path = new File(Grasscutter.getConfig().DATA_FOLDER).toPath();
                path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            }
            catch (Exception e) {
                Grasscutter.getLogger().error("Unable to load the Gacha Manager Watch Service. If ServerOptions.watchGacha is true it will not auto-reload");
                e.printStackTrace();
            }
        } else {
            Grasscutter.getLogger().error("Cannot reinitialise watcher ");
        }
    }

    @Subscribe
    public synchronized void watchBannerJson(GameServerTickEvent tickEvent) {
        if (Grasscutter.getConfig().getGameServerOptions().WatchGacha) {
            try {
                WatchKey watchKey = this.watchService.take();
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Path changed = (Path)event.context();
                    if (!changed.endsWith("Banners.json")) continue;
                    Grasscutter.getLogger().info("Change detected with banners.json. Reloading gacha config");
                    this.load();
                }
                boolean valid = watchKey.reset();
                if (!valid) {
                    Grasscutter.getLogger().error("Unable to reset Gacha Manager Watch Key. Auto-reload of banners.json will no longer work.");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    private synchronized GetGachaInfoRspOuterClass.GetGachaInfoRsp createProto() {
        GetGachaInfoRspOuterClass.GetGachaInfoRsp.Builder proto = GetGachaInfoRspOuterClass.GetGachaInfoRsp.newBuilder().setGachaRandom(12345);
        for (GachaBanner banner : this.getGachaBanners().values()) {
            proto.addGachaInfoList(banner.toProto());
        }
        return proto.build();
    }

    private synchronized GetGachaInfoRspOuterClass.GetGachaInfoRsp createProto(String sessionKey) {
        GetGachaInfoRspOuterClass.GetGachaInfoRsp.Builder proto = GetGachaInfoRspOuterClass.GetGachaInfoRsp.newBuilder().setGachaRandom(12345);
        for (GachaBanner banner : this.getGachaBanners().values()) {
            proto.addGachaInfoList(banner.toProto(sessionKey));
        }
        return proto.build();
    }

    @Deprecated
    public GetGachaInfoRspOuterClass.GetGachaInfoRsp toProto() {
        if (this.cachedProto == null) {
            this.cachedProto = this.createProto();
        }
        return this.cachedProto;
    }

    public GetGachaInfoRspOuterClass.GetGachaInfoRsp toProto(String sessionKey) {
        return this.createProto(sessionKey);
    }
}

