/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.LifeState;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.game.world.SpawnDataEntry;
import emu.grasscutter.game.world.World;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.MotionStateOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.utils.Position;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;

public abstract class GameEntity {
    protected int id;
    private final Scene scene;
    private SpawnDataEntry spawnEntry;
    private int blockId;
    private int configId;
    private int groupId;
    private MotionStateOuterClass.MotionState moveState;
    private int lastMoveSceneTimeMs;
    private int lastMoveReliableSeq;

    public GameEntity(Scene scene) {
        this.scene = scene;
        this.moveState = MotionStateOuterClass.MotionState.MOTION_NONE;
    }

    public int getId() {
        return this.id;
    }

    public int getEntityType() {
        return this.getId() >> 24;
    }

    public World getWorld() {
        return this.getScene().getWorld();
    }

    public Scene getScene() {
        return this.scene;
    }

    public boolean isAlive() {
        return true;
    }

    public LifeState getLifeState() {
        return this.isAlive() ? LifeState.LIFE_ALIVE : LifeState.LIFE_DEAD;
    }

    public abstract Int2FloatOpenHashMap getFightProperties();

    public abstract Position getPosition();

    public abstract Position getRotation();

    public MotionStateOuterClass.MotionState getMotionState() {
        return this.moveState;
    }

    public void setMotionState(MotionStateOuterClass.MotionState moveState) {
        this.moveState = moveState;
    }

    public int getLastMoveSceneTimeMs() {
        return this.lastMoveSceneTimeMs;
    }

    public void setLastMoveSceneTimeMs(int lastMoveSceneTimeMs) {
        this.lastMoveSceneTimeMs = lastMoveSceneTimeMs;
    }

    public int getLastMoveReliableSeq() {
        return this.lastMoveReliableSeq;
    }

    public void setLastMoveReliableSeq(int lastMoveReliableSeq) {
        this.lastMoveReliableSeq = lastMoveReliableSeq;
    }

    public abstract SceneEntityInfoOuterClass.SceneEntityInfo toProto();

    public abstract void onDeath(int var1);

    public void setFightProperty(FightProperty prop, float value) {
        this.getFightProperties().put(prop.getId(), value);
    }

    private void setFightProperty(int id, float value) {
        this.getFightProperties().put(id, value);
    }

    public void addFightProperty(FightProperty prop, float value) {
        this.getFightProperties().put(prop.getId(), this.getFightProperty(prop) + value);
    }

    public float getFightProperty(FightProperty prop) {
        return this.getFightProperties().getOrDefault(prop.getId(), 0.0f);
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getConfigId() {
        return this.configId;
    }

    public void setConfigId(int configId) {
        this.configId = configId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    protected MotionInfoOuterClass.MotionInfo getMotionInfo() {
        MotionInfoOuterClass.MotionInfo proto = MotionInfoOuterClass.MotionInfo.newBuilder().setPos(this.getPosition().toProto()).setRot(this.getRotation().toProto()).setSpeed(VectorOuterClass.Vector.newBuilder()).setState(this.getMotionState()).build();
        return proto;
    }

    public SpawnDataEntry getSpawnEntry() {
        return this.spawnEntry;
    }

    public void setSpawnEntry(SpawnDataEntry spawnEntry) {
        this.spawnEntry = spawnEntry;
    }
}

