/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.PropGrowCurve;
import emu.grasscutter.data.def.MonsterCurveData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.AnimatorParameterValueInfoPairOuterClass;
import emu.grasscutter.net.proto.EntityAuthorityInfoOuterClass;
import emu.grasscutter.net.proto.EntityClientDataOuterClass;
import emu.grasscutter.net.proto.EntityRendererChangedInfoOuterClass;
import emu.grasscutter.net.proto.FightPropPairOuterClass;
import emu.grasscutter.net.proto.MonsterBornTypeOuterClass;
import emu.grasscutter.net.proto.PropPairOuterClass;
import emu.grasscutter.net.proto.ProtEntityTypeOuterClass;
import emu.grasscutter.net.proto.SceneEntityAiInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.SceneMonsterInfoOuterClass;
import emu.grasscutter.net.proto.SceneWeaponInfoOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.ProtoHelper;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;

public class EntityMonster
extends GameEntity {
    private final MonsterData monsterData;
    private final Int2FloatOpenHashMap fightProp;
    private final Position pos;
    private final Position rot;
    private final Position bornPos;
    private final int level;
    private int weaponEntityId;
    private int poseId;

    public EntityMonster(Scene scene, MonsterData monsterData, Position pos, int level) {
        super(scene);
        this.id = this.getWorld().getNextEntityId(EntityIdType.MONSTER);
        this.monsterData = monsterData;
        this.fightProp = new Int2FloatOpenHashMap();
        this.pos = new Position(pos);
        this.rot = new Position();
        this.bornPos = this.getPosition().clone();
        this.level = level;
        if (this.getMonsterWeaponId() > 0) {
            this.weaponEntityId = this.getWorld().getNextEntityId(EntityIdType.WEAPON);
        }
        this.recalcStats();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public MonsterData getMonsterData() {
        return this.monsterData;
    }

    public int getMonsterWeaponId() {
        return this.getMonsterData().getWeaponId();
    }

    private int getMonsterId() {
        return this.getMonsterData().getId();
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public Position getPosition() {
        return this.pos;
    }

    @Override
    public Position getRotation() {
        return this.rot;
    }

    public Position getBornPos() {
        return this.bornPos;
    }

    @Override
    public Int2FloatOpenHashMap getFightProperties() {
        return this.fightProp;
    }

    @Override
    public boolean isAlive() {
        return this.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) > 0.0f;
    }

    public int getPoseId() {
        return this.poseId;
    }

    public void setPoseId(int poseId) {
        this.poseId = poseId;
    }

    @Override
    public void onDeath(int killerId) {
        if (this.getSpawnEntry() != null) {
            this.getScene().getDeadSpawnedEntities().add(this.getSpawnEntry());
        }
        if (this.getScene().getScriptManager().isInit() && this.getGroupId() > 0) {
            this.getScene().getScriptManager().callEvent(1, null);
        }
        if (this.getScene().getChallenge() != null && this.getScene().getChallenge().getGroup().id == this.getGroupId()) {
            this.getScene().getChallenge().onMonsterDie(this);
        }
    }

    public void recalcStats() {
        MonsterData data = this.getMonsterData();
        float hpPercent = this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) <= 0.0f ? 1.0f : this.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) / this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP);
        this.getFightProperties().clear();
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_HP, data.getBaseHp());
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK, data.getBaseAttack());
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_DEFENSE, data.getBaseDefense());
        this.setFightProperty(FightProperty.FIGHT_PROP_PHYSICAL_SUB_HURT, data.getPhysicalSubHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_FIRE_SUB_HURT, 0.1f);
        this.setFightProperty(FightProperty.FIGHT_PROP_ELEC_SUB_HURT, data.getElecSubHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_WATER_SUB_HURT, data.getWaterSubHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_GRASS_SUB_HURT, data.getGrassSubHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_WIND_SUB_HURT, data.getWindSubHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_ROCK_SUB_HURT, 0.1f);
        this.setFightProperty(FightProperty.FIGHT_PROP_ICE_SUB_HURT, data.getIceSubHurt());
        MonsterCurveData curve = (MonsterCurveData)GameData.getMonsterCurveDataMap().get(this.getLevel());
        if (curve != null) {
            for (PropGrowCurve growCurve : data.getPropGrowCurves()) {
                FightProperty prop = FightProperty.getPropByName(growCurve.getType());
                this.setFightProperty(prop, this.getFightProperty(prop) * curve.getMultByProp(growCurve.getGrowCurve()));
            }
        }
        this.setFightProperty(FightProperty.FIGHT_PROP_MAX_HP, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_HP) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_HP_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_HP));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_ATTACK_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_ATTACK));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_DEFENSE) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_DEFENSE_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_DEFENSE));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * hpPercent);
    }

    @Override
    public SceneEntityInfoOuterClass.SceneEntityInfo toProto() {
        EntityAuthorityInfoOuterClass.EntityAuthorityInfo authority = EntityAuthorityInfoOuterClass.EntityAuthorityInfo.newBuilder().setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).setRendererChangedInfo(EntityRendererChangedInfoOuterClass.EntityRendererChangedInfo.newBuilder()).setAiInfo(SceneEntityAiInfoOuterClass.SceneEntityAiInfo.newBuilder().setIsAiOpen(true).setBornPos(this.getBornPos().toProto())).setBornPos(this.getBornPos().toProto()).build();
        SceneEntityInfoOuterClass.SceneEntityInfo.Builder entityInfo = SceneEntityInfoOuterClass.SceneEntityInfo.newBuilder().setEntityId(this.getId()).setEntityType(ProtEntityTypeOuterClass.ProtEntityType.PROT_ENTITY_MONSTER).setMotionInfo(this.getMotionInfo()).addAnimatorParaList(AnimatorParameterValueInfoPairOuterClass.AnimatorParameterValueInfoPair.newBuilder()).setEntityClientData(EntityClientDataOuterClass.EntityClientData.newBuilder()).setEntityAuthorityInfo(authority).setLifeState(this.getLifeState().getValue());
        for (Int2FloatMap.Entry entry : this.getFightProperties().int2FloatEntrySet()) {
            if (entry.getIntKey() == 0) continue;
            FightPropPairOuterClass.FightPropPair fightProp = FightPropPairOuterClass.FightPropPair.newBuilder().setPropType(entry.getIntKey()).setPropValue(entry.getFloatValue()).build();
            entityInfo.addFightPropList(fightProp);
        }
        PropPairOuterClass.PropPair pair = PropPairOuterClass.PropPair.newBuilder().setType(PlayerProperty.PROP_LEVEL.getId()).setPropValue(ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, this.getLevel())).build();
        entityInfo.addPropList(pair);
        SceneMonsterInfoOuterClass.SceneMonsterInfo.Builder monsterInfo = SceneMonsterInfoOuterClass.SceneMonsterInfo.newBuilder().setMonsterId(this.getMonsterId()).setGroupId(this.getGroupId()).setConfigId(this.getConfigId()).addAllAffixList(this.getMonsterData().getAffix()).setAuthorityPeerId(this.getWorld().getHostPeerId()).setPoseId(this.getPoseId()).setBlockId(3001).setBornType(MonsterBornTypeOuterClass.MonsterBornType.MONSTER_BORN_DEFAULT).setSpecialNameId(40);
        if (this.getMonsterData().getDescribeData() != null) {
            monsterInfo.setTitleId(this.getMonsterData().getDescribeData().getTitleID());
        }
        if (this.getMonsterWeaponId() > 0) {
            SceneWeaponInfoOuterClass.SceneWeaponInfo weaponInfo = SceneWeaponInfoOuterClass.SceneWeaponInfo.newBuilder().setEntityId(this.weaponEntityId).setGadgetId(this.getMonsterWeaponId()).setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).build();
            monsterInfo.addWeaponList(weaponInfo);
        }
        entityInfo.setMonster(monsterInfo);
        return entityInfo.build();
    }
}

