/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.entity.EntityBaseGadget;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.AnimatorParameterValueInfoPairOuterClass;
import emu.grasscutter.net.proto.EntityAuthorityInfoOuterClass;
import emu.grasscutter.net.proto.EntityClientDataOuterClass;
import emu.grasscutter.net.proto.EntityRendererChangedInfoOuterClass;
import emu.grasscutter.net.proto.GadgetBornTypeOuterClass;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.PropPairOuterClass;
import emu.grasscutter.net.proto.ProtEntityTypeOuterClass;
import emu.grasscutter.net.proto.SceneEntityAiInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.SceneGadgetInfoOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.ProtoHelper;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;

public class EntityItem
extends EntityBaseGadget {
    private final Position pos;
    private final Position rot;
    private final GameItem item;
    private final long guid;
    private final boolean share;

    public EntityItem(Scene scene, Player player, ItemData itemData, Position pos, int count) {
        super(scene);
        this.id = this.getScene().getWorld().getNextEntityId(EntityIdType.GADGET);
        this.pos = new Position(pos);
        this.rot = new Position();
        this.guid = player == null ? scene.getWorld().getHost().getNextGameGuid() : player.getNextGameGuid();
        this.item = new GameItem(itemData, count);
        this.share = true;
    }

    public EntityItem(Scene scene, Player player, ItemData itemData, Position pos, int count, boolean share) {
        super(scene);
        this.id = this.getScene().getWorld().getNextEntityId(EntityIdType.GADGET);
        this.pos = new Position(pos);
        this.rot = new Position();
        this.guid = player == null ? scene.getWorld().getHost().getNextGameGuid() : player.getNextGameGuid();
        this.item = new GameItem(itemData, count);
        this.share = share;
    }

    @Override
    public int getId() {
        return this.id;
    }

    private GameItem getItem() {
        return this.item;
    }

    public ItemData getItemData() {
        return this.getItem().getItemData();
    }

    public long getGuid() {
        return this.guid;
    }

    public int getCount() {
        return this.getItem().getCount();
    }

    @Override
    public int getGadgetId() {
        return this.getItemData().getGadgetId();
    }

    @Override
    public Position getPosition() {
        return this.pos;
    }

    @Override
    public Position getRotation() {
        return this.rot;
    }

    @Override
    public Int2FloatOpenHashMap getFightProperties() {
        return null;
    }

    public boolean isShare() {
        return this.share;
    }

    @Override
    public SceneEntityInfoOuterClass.SceneEntityInfo toProto() {
        EntityAuthorityInfoOuterClass.EntityAuthorityInfo authority = EntityAuthorityInfoOuterClass.EntityAuthorityInfo.newBuilder().setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).setRendererChangedInfo(EntityRendererChangedInfoOuterClass.EntityRendererChangedInfo.newBuilder()).setAiInfo(SceneEntityAiInfoOuterClass.SceneEntityAiInfo.newBuilder().setIsAiOpen(true).setBornPos(VectorOuterClass.Vector.newBuilder())).setBornPos(VectorOuterClass.Vector.newBuilder()).build();
        SceneEntityInfoOuterClass.SceneEntityInfo.Builder entityInfo = SceneEntityInfoOuterClass.SceneEntityInfo.newBuilder().setEntityId(this.getId()).setEntityType(ProtEntityTypeOuterClass.ProtEntityType.PROT_ENTITY_GADGET).setMotionInfo(MotionInfoOuterClass.MotionInfo.newBuilder().setPos(this.getPosition().toProto()).setRot(this.getRotation().toProto()).setSpeed(VectorOuterClass.Vector.newBuilder())).addAnimatorParaList(AnimatorParameterValueInfoPairOuterClass.AnimatorParameterValueInfoPair.newBuilder()).setEntityClientData(EntityClientDataOuterClass.EntityClientData.newBuilder()).setEntityAuthorityInfo(authority).setLifeState(1);
        PropPairOuterClass.PropPair pair = PropPairOuterClass.PropPair.newBuilder().setType(PlayerProperty.PROP_LEVEL.getId()).setPropValue(ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, 1)).build();
        entityInfo.addPropList(pair);
        SceneGadgetInfoOuterClass.SceneGadgetInfo.Builder gadgetInfo = SceneGadgetInfoOuterClass.SceneGadgetInfo.newBuilder().setGadgetId(this.getItemData().getGadgetId()).setTrifleItem(this.getItem().toProto()).setBornType(GadgetBornTypeOuterClass.GadgetBornType.GADGET_BORN_IN_AIR).setAuthorityPeerId(this.getWorld().getHostPeerId()).setIsEnableInteract(true);
        entityInfo.setGadget(gadgetInfo);
        return entityInfo.build();
    }
}

