/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.game.entity.EntityBaseGadget;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.AnimatorParameterValueInfoPairOuterClass;
import emu.grasscutter.net.proto.ClientGadgetInfoOuterClass;
import emu.grasscutter.net.proto.EntityAuthorityInfoOuterClass;
import emu.grasscutter.net.proto.EntityClientDataOuterClass;
import emu.grasscutter.net.proto.EntityRendererChangedInfoOuterClass;
import emu.grasscutter.net.proto.EvtCreateGadgetNotifyOuterClass;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.PropPairOuterClass;
import emu.grasscutter.net.proto.ProtEntityTypeOuterClass;
import emu.grasscutter.net.proto.SceneEntityAiInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.SceneGadgetInfoOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.ProtoHelper;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;

public class EntityClientGadget
extends EntityBaseGadget {
    private final Player owner;
    private final Position pos;
    private final Position rot;
    private int configId;
    private int campId;
    private int campType;
    private int ownerEntityId;
    private int targetEntityId;
    private boolean asyncLoad;

    public EntityClientGadget(Scene scene, Player player, EvtCreateGadgetNotifyOuterClass.EvtCreateGadgetNotify notify) {
        super(scene);
        this.owner = player;
        this.id = notify.getEntityId();
        this.pos = new Position(notify.getInitPos());
        this.rot = new Position(notify.getInitEulerAngles());
        this.configId = notify.getConfigId();
        this.campId = notify.getCampId();
        this.campType = notify.getCampType();
        this.ownerEntityId = notify.getPropOwnerEntityId();
        this.targetEntityId = notify.getTargetEntityId();
        this.asyncLoad = notify.getIsAsyncLoad();
    }

    @Override
    public int getGadgetId() {
        return this.configId;
    }

    public Player getOwner() {
        return this.owner;
    }

    public int getCampId() {
        return this.campId;
    }

    public int getCampType() {
        return this.campType;
    }

    public int getOwnerEntityId() {
        return this.ownerEntityId;
    }

    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    public boolean isAsyncLoad() {
        return this.asyncLoad;
    }

    @Override
    public void onDeath(int killerId) {
    }

    @Override
    public Int2FloatOpenHashMap getFightProperties() {
        return null;
    }

    @Override
    public Position getPosition() {
        return this.pos;
    }

    @Override
    public Position getRotation() {
        return this.rot;
    }

    @Override
    public SceneEntityInfoOuterClass.SceneEntityInfo toProto() {
        EntityAuthorityInfoOuterClass.EntityAuthorityInfo authority = EntityAuthorityInfoOuterClass.EntityAuthorityInfo.newBuilder().setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).setRendererChangedInfo(EntityRendererChangedInfoOuterClass.EntityRendererChangedInfo.newBuilder()).setAiInfo(SceneEntityAiInfoOuterClass.SceneEntityAiInfo.newBuilder().setIsAiOpen(true).setBornPos(VectorOuterClass.Vector.newBuilder())).setBornPos(VectorOuterClass.Vector.newBuilder()).build();
        SceneEntityInfoOuterClass.SceneEntityInfo.Builder entityInfo = SceneEntityInfoOuterClass.SceneEntityInfo.newBuilder().setEntityId(this.getId()).setEntityType(ProtEntityTypeOuterClass.ProtEntityType.PROT_ENTITY_GADGET).setMotionInfo(MotionInfoOuterClass.MotionInfo.newBuilder().setPos(this.getPosition().toProto()).setRot(this.getRotation().toProto()).setSpeed(VectorOuterClass.Vector.newBuilder())).addAnimatorParaList(AnimatorParameterValueInfoPairOuterClass.AnimatorParameterValueInfoPair.newBuilder()).setEntityClientData(EntityClientDataOuterClass.EntityClientData.newBuilder()).setEntityAuthorityInfo(authority).setLifeState(1);
        PropPairOuterClass.PropPair pair = PropPairOuterClass.PropPair.newBuilder().setType(PlayerProperty.PROP_LEVEL.getId()).setPropValue(ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, 1)).build();
        entityInfo.addPropList(pair);
        ClientGadgetInfoOuterClass.ClientGadgetInfo clientGadget = ClientGadgetInfoOuterClass.ClientGadgetInfo.newBuilder().setCampId(this.getCampId()).setCampType(this.getCampType()).setOwnerEntityId(this.getOwnerEntityId()).setTargetEntityId(this.getTargetEntityId()).setAsyncLoad(this.isAsyncLoad()).build();
        SceneGadgetInfoOuterClass.SceneGadgetInfo.Builder gadgetInfo = SceneGadgetInfoOuterClass.SceneGadgetInfo.newBuilder().setGadgetId(this.getGadgetId()).setOwnerEntityId(this.getOwnerEntityId()).setIsEnableInteract(true).setClientGadget(clientGadget).setPropOwnerEntityId(this.getOwnerEntityId()).setAuthorityPeerId(this.getOwner().getPeerId());
        entityInfo.setGadget(gadgetInfo);
        return entityInfo.build();
    }
}

