/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.GameConstants;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.inventory.EquipType;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.proto.AbilityControlBlockOuterClass;
import emu.grasscutter.net.proto.AbilityEmbryoOuterClass;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.AnimatorParameterValueInfoPairOuterClass;
import emu.grasscutter.net.proto.EntityAuthorityInfoOuterClass;
import emu.grasscutter.net.proto.EntityClientDataOuterClass;
import emu.grasscutter.net.proto.EntityRendererChangedInfoOuterClass;
import emu.grasscutter.net.proto.FightPropPairOuterClass;
import emu.grasscutter.net.proto.PlayerDieTypeOuterClass;
import emu.grasscutter.net.proto.PropPairOuterClass;
import emu.grasscutter.net.proto.ProtEntityTypeOuterClass;
import emu.grasscutter.net.proto.SceneAvatarInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityAiInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.ProtoHelper;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;

public class EntityAvatar
extends GameEntity {
    private final Avatar avatar;
    private PlayerDieTypeOuterClass.PlayerDieType killedType;
    private int killedBy;

    public EntityAvatar(Scene scene, Avatar avatar) {
        super(scene);
        this.avatar = avatar;
        this.id = this.getScene().getWorld().getNextEntityId(EntityIdType.AVATAR);
        GameItem weapon = this.getAvatar().getWeapon();
        if (weapon != null) {
            weapon.setWeaponEntityId(this.getScene().getWorld().getNextEntityId(EntityIdType.WEAPON));
        }
    }

    public EntityAvatar(Avatar avatar) {
        super(null);
        this.avatar = avatar;
    }

    public Player getPlayer() {
        return this.avatar.getPlayer();
    }

    @Override
    public Position getPosition() {
        return this.getPlayer().getPos();
    }

    @Override
    public Position getRotation() {
        return this.getPlayer().getRotation();
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public int getKilledBy() {
        return this.killedBy;
    }

    public PlayerDieTypeOuterClass.PlayerDieType getKilledType() {
        return this.killedType;
    }

    @Override
    public boolean isAlive() {
        return this.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) > 0.0f;
    }

    @Override
    public Int2FloatOpenHashMap getFightProperties() {
        return this.getAvatar().getFightProperties();
    }

    public int getWeaponEntityId() {
        if (this.getAvatar().getWeapon() != null) {
            return this.getAvatar().getWeapon().getWeaponEntityId();
        }
        return 0;
    }

    @Override
    public void onDeath(int killerId) {
        this.killedType = PlayerDieTypeOuterClass.PlayerDieType.PLAYER_DIE_KILL_BY_MONSTER;
        this.killedBy = killerId;
    }

    public SceneAvatarInfoOuterClass.SceneAvatarInfo getSceneAvatarInfo() {
        SceneAvatarInfoOuterClass.SceneAvatarInfo.Builder avatarInfo = SceneAvatarInfoOuterClass.SceneAvatarInfo.newBuilder().setUid(this.getPlayer().getUid()).setAvatarId(this.getAvatar().getAvatarId()).setGuid(this.getAvatar().getGuid()).setPeerId(this.getPlayer().getPeerId()).addAllTalentIdList(this.getAvatar().getTalentIdList()).setCoreProudSkillLevel(this.getAvatar().getCoreProudSkillLevel()).putAllSkillLevelMap(this.getAvatar().getSkillLevelMap()).setSkillDepotId(this.getAvatar().getSkillDepotId()).addAllInherentProudSkillList(this.getAvatar().getProudSkillList()).putAllProudSkillExtraLevelMap(this.getAvatar().getProudSkillBonusMap()).addAllTeamResonanceList(this.getAvatar().getPlayer().getTeamManager().getTeamResonances()).setWearingFlycloakId(this.getAvatar().getFlyCloak()).setCostumeId(this.getAvatar().getCostume()).setBornTime(this.getAvatar().getBornTime());
        for (GameItem item : this.avatar.getEquips().values()) {
            if (item.getItemData().getEquipType() == EquipType.EQUIP_WEAPON) {
                avatarInfo.setWeapon(item.createSceneWeaponInfo());
            } else {
                avatarInfo.addReliquaryList(item.createSceneReliquaryInfo());
            }
            avatarInfo.addEquipIdList(item.getItemId());
        }
        return avatarInfo.build();
    }

    @Override
    public SceneEntityInfoOuterClass.SceneEntityInfo toProto() {
        EntityAuthorityInfoOuterClass.EntityAuthorityInfo authority = EntityAuthorityInfoOuterClass.EntityAuthorityInfo.newBuilder().setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).setRendererChangedInfo(EntityRendererChangedInfoOuterClass.EntityRendererChangedInfo.newBuilder()).setAiInfo(SceneEntityAiInfoOuterClass.SceneEntityAiInfo.newBuilder().setIsAiOpen(true).setBornPos(VectorOuterClass.Vector.newBuilder())).setBornPos(VectorOuterClass.Vector.newBuilder()).build();
        SceneEntityInfoOuterClass.SceneEntityInfo.Builder entityInfo = SceneEntityInfoOuterClass.SceneEntityInfo.newBuilder().setEntityId(this.getId()).setEntityType(ProtEntityTypeOuterClass.ProtEntityType.PROT_ENTITY_AVATAR).addAnimatorParaList(AnimatorParameterValueInfoPairOuterClass.AnimatorParameterValueInfoPair.newBuilder()).setEntityClientData(EntityClientDataOuterClass.EntityClientData.newBuilder()).setEntityAuthorityInfo(authority).setLastMoveSceneTimeMs(this.getLastMoveSceneTimeMs()).setLastMoveReliableSeq(this.getLastMoveReliableSeq()).setLifeState(this.getLifeState().getValue());
        if (this.getScene() != null) {
            entityInfo.setMotionInfo(this.getMotionInfo());
        }
        for (Int2FloatMap.Entry entry : this.getFightProperties().int2FloatEntrySet()) {
            if (entry.getIntKey() == 0) continue;
            FightPropPairOuterClass.FightPropPair fightProp = FightPropPairOuterClass.FightPropPair.newBuilder().setPropType(entry.getIntKey()).setPropValue(entry.getFloatValue()).build();
            entityInfo.addFightPropList(fightProp);
        }
        PropPairOuterClass.PropPair pair = PropPairOuterClass.PropPair.newBuilder().setType(PlayerProperty.PROP_LEVEL.getId()).setPropValue(ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, this.getAvatar().getLevel())).build();
        entityInfo.addPropList(pair);
        entityInfo.setAvatar(this.getSceneAvatarInfo());
        return entityInfo.build();
    }

    public AbilityControlBlockOuterClass.AbilityControlBlock getAbilityControlBlock() {
        int id;
        Object object;
        AvatarData data = this.getAvatar().getAvatarData();
        AbilityControlBlockOuterClass.AbilityControlBlock.Builder abilityControlBlock = AbilityControlBlockOuterClass.AbilityControlBlock.newBuilder();
        int embryoId = 0;
        if (data.getAbilities() != null) {
            object = data.getAbilities().iterator();
            while (object.hasNext()) {
                id = (Integer)object.next();
                AbilityEmbryoOuterClass.AbilityEmbryo emb = AbilityEmbryoOuterClass.AbilityEmbryo.newBuilder().setAbilityId(++embryoId).setAbilityNameHash(id).setAbilityOverrideNameHash(GameConstants.DEFAULT_ABILITY_NAME).build();
                abilityControlBlock.addAbilityEmbryoList(emb);
            }
        }
        for (int id2 : GameConstants.DEFAULT_ABILITY_HASHES) {
            AbilityEmbryoOuterClass.AbilityEmbryo emb = AbilityEmbryoOuterClass.AbilityEmbryo.newBuilder().setAbilityId(++embryoId).setAbilityNameHash(id2).setAbilityOverrideNameHash(GameConstants.DEFAULT_ABILITY_NAME).build();
            abilityControlBlock.addAbilityEmbryoList(emb);
        }
        object = this.getPlayer().getTeamManager().getTeamResonancesConfig().iterator();
        while (object.hasNext()) {
            id = (Integer)object.next();
            AbilityEmbryoOuterClass.AbilityEmbryo emb = AbilityEmbryoOuterClass.AbilityEmbryo.newBuilder().setAbilityId(++embryoId).setAbilityNameHash(id).setAbilityOverrideNameHash(GameConstants.DEFAULT_ABILITY_NAME).build();
            abilityControlBlock.addAbilityEmbryoList(emb);
        }
        AvatarSkillDepotData skillDepot = (AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(this.getAvatar().getSkillDepotId());
        if (skillDepot != null && skillDepot.getAbilities() != null) {
            IntListIterator intListIterator = skillDepot.getAbilities().iterator();
            while (intListIterator.hasNext()) {
                int id3 = (Integer)intListIterator.next();
                AbilityEmbryoOuterClass.AbilityEmbryo emb = AbilityEmbryoOuterClass.AbilityEmbryo.newBuilder().setAbilityId(++embryoId).setAbilityNameHash(id3).setAbilityOverrideNameHash(GameConstants.DEFAULT_ABILITY_NAME).build();
                abilityControlBlock.addAbilityEmbryoList(emb);
            }
        }
        if (this.getAvatar().getExtraAbilityEmbryos().size() > 0) {
            for (String skill : this.getAvatar().getExtraAbilityEmbryos()) {
                AbilityEmbryoOuterClass.AbilityEmbryo emb = AbilityEmbryoOuterClass.AbilityEmbryo.newBuilder().setAbilityId(++embryoId).setAbilityNameHash(Utils.abilityHash(skill)).setAbilityOverrideNameHash(GameConstants.DEFAULT_ABILITY_NAME).build();
                abilityControlBlock.addAbilityEmbryoList(emb);
            }
        }
        return abilityControlBlock.build();
    }
}

