/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.dungeons;

import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.server.packet.send.PacketChallengeDataNotify;
import emu.grasscutter.server.packet.send.PacketDungeonChallengeBeginNotify;
import emu.grasscutter.server.packet.send.PacketDungeonChallengeFinishNotify;

public class DungeonChallenge {
    private final Scene scene;
    private final SceneGroup group;
    private int challengeIndex;
    private int challengeId;
    private boolean success;
    private boolean progress;
    private int score;
    private int objective = 0;

    public DungeonChallenge(Scene scene, SceneGroup group) {
        this.scene = scene;
        this.group = group;
        this.objective += group.monsters.size();
    }

    public Scene getScene() {
        return this.scene;
    }

    public SceneGroup getGroup() {
        return this.group;
    }

    public int getChallengeIndex() {
        return this.challengeIndex;
    }

    public void setChallengeIndex(int challengeIndex) {
        this.challengeIndex = challengeIndex;
    }

    public int getChallengeId() {
        return this.challengeId;
    }

    public void setChallengeId(int challengeId) {
        this.challengeId = challengeId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean isSuccess) {
        this.success = isSuccess;
    }

    public boolean inProgress() {
        return this.progress;
    }

    public int getScore() {
        return this.score;
    }

    public void start() {
        this.progress = true;
        this.getScene().broadcastPacket(new PacketDungeonChallengeBeginNotify(this));
    }

    public void finish() {
        this.progress = false;
        this.getScene().broadcastPacket(new PacketDungeonChallengeFinishNotify(this));
        if (this.isSuccess()) {
            this.getScene().getScriptManager().callEvent(16, null);
        } else {
            this.getScene().getScriptManager().callEvent(17, null);
        }
    }

    public void onMonsterDie(EntityMonster entity) {
        this.score = this.getScore() + 1;
        this.getScene().broadcastPacket(new PacketChallengeDataNotify(this, 1, this.getScore()));
        if (this.getScore() >= this.objective) {
            this.setSuccess(true);
            this.finish();
        }
    }
}

