/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.drop;

import com.google.gson.reflect.TypeToken;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.drop.DropData;
import emu.grasscutter.game.drop.DropInfo;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class DropManager {
    private final GameServer gameServer;
    private final Int2ObjectMap<List<DropData>> dropData;

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public Int2ObjectMap<List<DropData>> getDropData() {
        return this.dropData;
    }

    public DropManager(GameServer gameServer) {
        this.gameServer = gameServer;
        this.dropData = new Int2ObjectOpenHashMap<List<DropData>>();
        this.load();
    }

    public synchronized void load() {
        try (FileReader fileReader = new FileReader(Grasscutter.getConfig().DATA_FOLDER + "Drop.json");){
            this.getDropData().clear();
            List banners = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{DropInfo.class}).getType());
            if (banners.size() > 0) {
                for (DropInfo di : banners) {
                    this.getDropData().put(di.getMonsterId(), di.getDropDataList());
                }
                Grasscutter.getLogger().info("Drop data successfully loaded.");
            } else {
                Grasscutter.getLogger().error("Unable to load drop data. Drop data size is 0.");
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load drop data.", e);
        }
    }

    private void addDropEntity(DropData dd, Scene dropScene, ItemData itemData, Position pos, int num, Player target) {
        if (!(dd.isGive() || itemData.getItemType() == ItemType.ITEM_VIRTUAL && itemData.getGadgetId() == 0)) {
            EntityItem entity = new EntityItem(dropScene, target, itemData, pos, num, dd.isShare());
            if (!dd.isShare()) {
                dropScene.addEntityToSingleClient(target, entity);
            } else {
                dropScene.addEntity(entity);
            }
        } else if (target != null) {
            target.getInventory().addItem(new GameItem(itemData, num), ActionReason.SubfieldDrop, true);
        } else {
            dropScene.getPlayers().forEach(x -> x.getInventory().addItem(new GameItem(itemData, num), ActionReason.SubfieldDrop, true));
        }
    }

    private void processDrop(DropData dd, EntityMonster em, Player gp) {
        int target = Utils.randomRange(1, 10000);
        if (target >= dd.getMinWeight() && target < dd.getMaxWeight()) {
            ItemData itemData = (ItemData)GameData.getItemDataMap().get(dd.getItemId());
            int num = Utils.randomRange(dd.getMinCount(), dd.getMaxCount());
            if (itemData == null) {
                return;
            }
            if (itemData.isEquip()) {
                for (int i2 = 0; i2 < num; ++i2) {
                    float range = 5.0f + 0.1f * (float)num;
                    Position pos = em.getPosition().clone().addX((float)(Math.random() * (double)range) - range / 2.0f).addY(3.0f).addZ((float)(Math.random() * (double)range) - range / 2.0f);
                    this.addDropEntity(dd, em.getScene(), itemData, pos, num, gp);
                }
            } else {
                Position pos = em.getPosition().clone().addY(3.0f);
                this.addDropEntity(dd, em.getScene(), itemData, pos, num, gp);
            }
        }
    }

    public void callDrop(EntityMonster em) {
        int id = em.getMonsterData().getId();
        if (this.getDropData().containsKey(id)) {
            for (DropData dd : (List)this.getDropData().get(id)) {
                if (dd.isShare()) {
                    this.processDrop(dd, em, null);
                    continue;
                }
                for (Player gp : em.getScene().getPlayers()) {
                    this.processDrop(dd, em, gp);
                }
            }
        }
    }
}

