/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.avatar;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.Transient;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.FightPropData;
import emu.grasscutter.data.custom.OpenConfigEntry;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.data.def.AvatarPromoteData;
import emu.grasscutter.data.def.AvatarSkillData;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.data.def.AvatarTalentData;
import emu.grasscutter.data.def.EquipAffixData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.ProudSkillData;
import emu.grasscutter.data.def.ReliquaryAffixData;
import emu.grasscutter.data.def.ReliquaryLevelData;
import emu.grasscutter.data.def.ReliquaryMainPropData;
import emu.grasscutter.data.def.ReliquarySetData;
import emu.grasscutter.data.def.WeaponCurveData;
import emu.grasscutter.data.def.WeaponPromoteData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.inventory.EquipType;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ElementType;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.FetterState;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.net.proto.AvatarFetterInfoOuterClass;
import emu.grasscutter.net.proto.AvatarInfoOuterClass;
import emu.grasscutter.net.proto.AvatarSkillInfoOuterClass;
import emu.grasscutter.net.proto.FetterDataOuterClass;
import emu.grasscutter.net.proto.ShowAvatarInfoOuterClass;
import emu.grasscutter.net.proto.ShowEquipOuterClass;
import emu.grasscutter.server.packet.send.PacketAbilityChangeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarEquipChangeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarFightPropNotify;
import emu.grasscutter.utils.ProtoHelper;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

@Entity(value="avatars", useDiscriminator=false)
public class Avatar {
    @Id
    private ObjectId id;
    @Indexed
    private int ownerId;
    @Transient
    private Player owner;
    @Transient
    private AvatarData data;
    @Transient
    private long guid;
    private int avatarId;
    private int level = 1;
    private int exp;
    private int promoteLevel;
    private int satiation;
    private int satiationPenalty;
    private float currentHp;
    @Transient
    private final Int2ObjectMap<GameItem> equips = new Int2ObjectOpenHashMap<GameItem>();
    @Transient
    private final Int2FloatOpenHashMap fightProp = new Int2FloatOpenHashMap();
    @Transient
    private Set<String> extraAbilityEmbryos = new HashSet<String>();
    private List<Integer> fetters;
    private Map<Integer, Integer> skillLevelMap;
    private Map<Integer, Integer> skillExtraChargeMap;
    private Map<Integer, Integer> proudSkillBonusMap = new HashMap<Integer, Integer>();
    private int skillDepotId;
    private int coreProudSkillLevel;
    private Set<Integer> talentIdList;
    private Set<Integer> proudSkillList;
    private int flyCloak;
    private int costume;
    private int bornTime;
    private int fetterLevel = 1;
    private int fetterExp;
    private int nameCardRewardId;
    private int nameCardId;

    public Avatar() {
        this.fetters = new ArrayList<Integer>();
    }

    public Avatar(int avatarId) {
        this((AvatarData)GameData.getAvatarDataMap().get(avatarId));
    }

    public Avatar(AvatarData data) {
        this();
        this.avatarId = data.getId();
        this.nameCardRewardId = data.getNameCardRewardId();
        this.nameCardId = data.getNameCardId();
        this.data = data;
        this.bornTime = (int)(System.currentTimeMillis() / 1000L);
        this.flyCloak = 140001;
        this.skillLevelMap = new HashMap<Integer, Integer>();
        this.skillExtraChargeMap = new HashMap<Integer, Integer>();
        this.talentIdList = new HashSet<Integer>();
        this.proudSkillList = new HashSet<Integer>();
        for (FightProperty prop : FightProperty.values()) {
            if (prop.getId() <= 0 || prop.getId() >= 3000) continue;
            this.setFightProperty(prop, 0.0f);
        }
        this.setSkillDepot(this.getAvatarData().getSkillDepot());
        this.recalcStats();
        this.currentHp = this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP);
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, this.currentHp);
        this.onLoad();
    }

    public Player getPlayer() {
        return this.owner;
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public AvatarData getAvatarData() {
        return this.data;
    }

    protected void setAvatarData(AvatarData data) {
        this.data = data;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwner(Player player) {
        this.owner = player;
        this.ownerId = player.getUid();
        this.guid = player.getNextGameGuid();
    }

    public int getSatiation() {
        return this.satiation;
    }

    public void setSatiation(int satiation) {
        this.satiation = satiation;
    }

    public int getNameCardRewardId() {
        return this.nameCardRewardId;
    }

    public void setNameCardRewardId(int nameCardRewardId) {
        this.nameCardRewardId = nameCardRewardId;
    }

    public int getSatiationPenalty() {
        return this.satiationPenalty;
    }

    public void setSatiationPenalty(int satiationPenalty) {
        this.satiationPenalty = satiationPenalty;
    }

    public AvatarData getData() {
        return this.data;
    }

    public long getGuid() {
        return this.guid;
    }

    public int getAvatarId() {
        return this.avatarId;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp2) {
        this.exp = exp2;
    }

    public int getPromoteLevel() {
        return this.promoteLevel;
    }

    public void setPromoteLevel(int promoteLevel) {
        this.promoteLevel = promoteLevel;
    }

    public Int2ObjectMap<GameItem> getEquips() {
        return this.equips;
    }

    public GameItem getEquipBySlot(EquipType slot) {
        return (GameItem)this.getEquips().get(slot.getValue());
    }

    private GameItem getEquipBySlot(int slotId) {
        return (GameItem)this.getEquips().get(slotId);
    }

    public GameItem getWeapon() {
        return this.getEquipBySlot(EquipType.EQUIP_WEAPON);
    }

    public int getSkillDepotId() {
        return this.skillDepotId;
    }

    public void setSkillDepot(AvatarSkillDepotData skillDepot) {
        this.skillDepotId = skillDepot.getId();
        this.getSkillLevelMap().clear();
        if (skillDepot.getEnergySkill() > 0) {
            this.getSkillLevelMap().put(skillDepot.getEnergySkill(), 1);
        }
        Iterator<Object> iterator2 = skillDepot.getSkills().iterator();
        while (iterator2.hasNext()) {
            int skillId = iterator2.next();
            if (skillId <= 0) continue;
            this.getSkillLevelMap().put(skillId, 1);
        }
        this.getProudSkillList().clear();
        for (AvatarSkillDepotData.InherentProudSkillOpens openData : skillDepot.getInherentProudSkillOpens()) {
            if (openData.getProudSkillGroupId() == 0 || openData.getNeedAvatarPromoteLevel() > this.getPromoteLevel()) continue;
            int proudSkillId = openData.getProudSkillGroupId() * 100 + 1;
            if (!GameData.getProudSkillDataMap().containsKey(proudSkillId)) continue;
            this.getProudSkillList().add(proudSkillId);
        }
    }

    public Map<Integer, Integer> getSkillLevelMap() {
        return this.skillLevelMap;
    }

    public Map<Integer, Integer> getSkillExtraChargeMap() {
        if (this.skillExtraChargeMap == null) {
            this.skillExtraChargeMap = new HashMap<Integer, Integer>();
        }
        return this.skillExtraChargeMap;
    }

    public Map<Integer, Integer> getProudSkillBonusMap() {
        return this.proudSkillBonusMap;
    }

    public Set<String> getExtraAbilityEmbryos() {
        return this.extraAbilityEmbryos;
    }

    public void setFetterList(List<Integer> fetterList) {
        this.fetters = fetterList;
    }

    public List<Integer> getFetterList() {
        return this.fetters;
    }

    public int getFetterLevel() {
        return this.fetterLevel;
    }

    public void setFetterLevel(int fetterLevel) {
        this.fetterLevel = fetterLevel;
    }

    public int getFetterExp() {
        return this.fetterExp;
    }

    public void setFetterExp(int fetterExp) {
        this.fetterExp = fetterExp;
    }

    public int getNameCardId() {
        return this.nameCardId;
    }

    public void setNameCardId(int nameCardId) {
        this.nameCardId = nameCardId;
    }

    public float getCurrentHp() {
        return this.currentHp;
    }

    public void setCurrentHp(float currentHp) {
        this.currentHp = currentHp;
    }

    public Int2FloatOpenHashMap getFightProperties() {
        return this.fightProp;
    }

    public void setFightProperty(FightProperty prop, float value) {
        this.getFightProperties().put(prop.getId(), value);
    }

    private void setFightProperty(int id, float value) {
        this.getFightProperties().put(id, value);
    }

    public void addFightProperty(FightProperty prop, float value) {
        this.getFightProperties().put(prop.getId(), this.getFightProperty(prop) + value);
    }

    public float getFightProperty(FightProperty prop) {
        return this.getFightProperties().getOrDefault(prop.getId(), 0.0f);
    }

    public Set<Integer> getTalentIdList() {
        return this.talentIdList;
    }

    public int getCoreProudSkillLevel() {
        return this.coreProudSkillLevel;
    }

    public void setCoreProudSkillLevel(int constLevel) {
        this.coreProudSkillLevel = constLevel;
    }

    public Set<Integer> getProudSkillList() {
        return this.proudSkillList;
    }

    public int getFlyCloak() {
        return this.flyCloak;
    }

    public void setFlyCloak(int flyCloak) {
        this.flyCloak = flyCloak;
    }

    public int getCostume() {
        return this.costume;
    }

    public void setCostume(int costume) {
        this.costume = costume;
    }

    public int getBornTime() {
        return this.bornTime;
    }

    public boolean equipItem(GameItem item, boolean shouldRecalc) {
        EquipType itemEquipType = item.getItemData().getEquipType();
        if (itemEquipType == EquipType.EQUIP_NONE) {
            return false;
        }
        if (this.getEquips().containsKey(itemEquipType.getValue())) {
            this.unequipItem(itemEquipType);
        }
        this.getEquips().put(itemEquipType.getValue(), item);
        if (itemEquipType == EquipType.EQUIP_WEAPON && this.getPlayer().getWorld() != null) {
            item.setWeaponEntityId(this.getPlayer().getWorld().getNextEntityId(EntityIdType.WEAPON));
        }
        item.setEquipCharacter(this.getAvatarId());
        item.save();
        if (this.getPlayer().hasSentAvatarDataNotify()) {
            this.getPlayer().sendPacket(new PacketAvatarEquipChangeNotify(this, item));
        }
        if (shouldRecalc) {
            this.recalcStats();
        }
        return true;
    }

    public boolean unequipItem(EquipType slot) {
        GameItem item = (GameItem)this.getEquips().remove(slot.getValue());
        if (item != null) {
            item.setEquipCharacter(0);
            item.save();
            return true;
        }
        return false;
    }

    public void recalcStats() {
        this.recalcStats(false);
    }

    public void recalcStats(boolean forceSendAbilityChange) {
        EquipAffixData affix;
        AvatarData data = this.getAvatarData();
        AvatarPromoteData promoteData = GameData.getAvatarPromoteData(data.getAvatarPromoteId(), this.getPromoteLevel());
        Int2IntOpenHashMap setMap = new Int2IntOpenHashMap();
        Set<String> prevExtraAbilityEmbryos = this.getExtraAbilityEmbryos();
        this.extraAbilityEmbryos = new HashSet<String>();
        this.setFetterList(data.getFetters());
        this.setNameCardRewardId(data.getNameCardRewardId());
        this.setNameCardId(data.getNameCardId());
        float hpPercent = this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) <= 0.0f ? 1.0f : this.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) / this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP);
        this.getFightProperties().clear();
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_HP, data.getBaseHp(this.getLevel()));
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK, data.getBaseAttack(this.getLevel()));
        this.setFightProperty(FightProperty.FIGHT_PROP_BASE_DEFENSE, data.getBaseDefense(this.getLevel()));
        this.setFightProperty(FightProperty.FIGHT_PROP_CRITICAL, data.getBaseCritical());
        this.setFightProperty(FightProperty.FIGHT_PROP_CRITICAL_HURT, data.getBaseCriticalHurt());
        this.setFightProperty(FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY, 1.0f);
        if (promoteData != null) {
            for (FightPropData fightPropData : promoteData.getAddProps()) {
                this.addFightProperty(fightPropData.getProp(), fightPropData.getValue());
            }
        }
        if (data.getSkillDepot() != null && data.getSkillDepot().getEnergySkillData() != null) {
            ElementType element = data.getSkillDepot().getElementType();
            this.setFightProperty(element.getEnergyProperty(), (float)data.getSkillDepot().getEnergySkillData().getCostElemVal());
            this.setFightProperty(element.getEnergyProperty().getId() % 70 + 1000, (float)data.getSkillDepot().getEnergySkillData().getCostElemVal());
        }
        for (int slotId = 1; slotId <= 5; ++slotId) {
            Object levelData;
            GameItem equip = this.getEquipBySlot(slotId);
            if (equip == null) continue;
            ReliquaryMainPropData mainPropData = (ReliquaryMainPropData)GameData.getReliquaryMainPropDataMap().get(equip.getMainPropId());
            if (mainPropData != null && (levelData = GameData.getRelicLevelData(equip.getItemData().getRankLevel(), equip.getLevel())) != null) {
                this.addFightProperty(mainPropData.getFightProp(), ((ReliquaryLevelData)levelData).getPropValue(mainPropData.getFightProp()));
            }
            levelData = equip.getAppendPropIdList().iterator();
            while (levelData.hasNext()) {
                int appendPropId = (Integer)levelData.next();
                ReliquaryAffixData affixData = (ReliquaryAffixData)GameData.getReliquaryAffixDataMap().get(appendPropId);
                if (affixData == null) continue;
                this.addFightProperty(affixData.getFightProp(), affixData.getPropValue());
            }
            if (equip.getItemData().getSetId() <= 0) continue;
            setMap.addTo(equip.getItemData().getSetId(), 1);
        }
        for (Int2IntMap.Entry e : setMap.int2IntEntrySet()) {
            ReliquarySetData setData = (ReliquarySetData)GameData.getReliquarySetDataMap().get(e.getIntKey());
            if (setData == null) continue;
            int amount = e.getIntValue();
            for (int setIndex = 0; setIndex < setData.getSetNeedNum().length && amount >= setData.getSetNeedNum()[setIndex]; ++setIndex) {
                int affixId = setData.getEquipAffixId() * 10 + setIndex;
                affix = (EquipAffixData)GameData.getEquipAffixDataMap().get(affixId);
                if (affix == null) continue;
                for (FightPropData prop : affix.getAddProps()) {
                    this.addFightProperty(prop.getProp(), prop.getValue());
                }
                this.addToExtraAbilityEmbryos(affix.getOpenConfig(), true);
            }
        }
        GameItem weapon = this.getWeapon();
        if (weapon != null) {
            WeaponPromoteData wepPromoteData;
            WeaponCurveData curveData = (WeaponCurveData)GameData.getWeaponCurveDataMap().get(weapon.getLevel());
            if (curveData != null) {
                for (ItemData.WeaponProperty weaponProperty : weapon.getItemData().getWeaponProperties()) {
                    this.addFightProperty(weaponProperty.getFightProp(), weaponProperty.getInitValue() * curveData.getMultByProp(weaponProperty.getType()));
                }
            }
            if ((wepPromoteData = GameData.getWeaponPromoteData(weapon.getItemData().getWeaponPromoteId(), weapon.getPromoteLevel())) != null) {
                for (FightPropData prop : wepPromoteData.getAddProps()) {
                    if (prop.getValue() == 0.0f || prop.getProp() == null) continue;
                    this.addFightProperty(prop.getProp(), prop.getValue());
                }
            }
            if (weapon.getAffixes() != null && weapon.getAffixes().size() > 0) {
                for (int af : weapon.getAffixes()) {
                    if (af == 0) continue;
                    int affixId = af * 10 + weapon.getRefinement();
                    affix = (EquipAffixData)GameData.getEquipAffixDataMap().get(affixId);
                    if (affix == null) continue;
                    for (FightPropData prop : affix.getAddProps()) {
                        this.addFightProperty(prop.getProp(), prop.getValue());
                    }
                    this.addToExtraAbilityEmbryos(affix.getOpenConfig(), true);
                }
            }
        }
        AvatarSkillDepotData skillDepot = (AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(this.getSkillDepotId());
        this.getProudSkillList().clear();
        for (AvatarSkillDepotData.InherentProudSkillOpens openData : skillDepot.getInherentProudSkillOpens()) {
            if (openData.getProudSkillGroupId() == 0 || openData.getNeedAvatarPromoteLevel() > this.getPromoteLevel()) continue;
            int proudSkillId = openData.getProudSkillGroupId() * 100 + 1;
            if (!GameData.getProudSkillDataMap().containsKey(proudSkillId)) continue;
            this.getProudSkillList().add(proudSkillId);
        }
        Iterator<Object> wepPromoteData = this.getProudSkillList().iterator();
        while (wepPromoteData.hasNext()) {
            int proudSkillId = (Integer)wepPromoteData.next();
            ProudSkillData proudSkillData = (ProudSkillData)GameData.getProudSkillDataMap().get(proudSkillId);
            if (proudSkillData == null) continue;
            for (FightPropData prop : proudSkillData.getAddProps()) {
                this.addFightProperty(prop.getProp(), prop.getValue());
            }
            this.addToExtraAbilityEmbryos(proudSkillData.getOpenConfig(), true);
        }
        if (this.getTalentIdList().size() > 0) {
            wepPromoteData = this.getTalentIdList().iterator();
            while (wepPromoteData.hasNext()) {
                int talentId = (Integer)wepPromoteData.next();
                AvatarTalentData avatarTalentData = (AvatarTalentData)GameData.getAvatarTalentDataMap().get(talentId);
                if (avatarTalentData == null) {
                    return;
                }
                this.addToExtraAbilityEmbryos(avatarTalentData.getOpenConfig(), false);
            }
        }
        this.setFightProperty(FightProperty.FIGHT_PROP_MAX_HP, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_HP) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_HP_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_HP));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_ATTACK_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_ATTACK));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, this.getFightProperty(FightProperty.FIGHT_PROP_BASE_DEFENSE) * (1.0f + this.getFightProperty(FightProperty.FIGHT_PROP_DEFENSE_PERCENT)) + this.getFightProperty(FightProperty.FIGHT_PROP_DEFENSE));
        this.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, this.getFightProperty(FightProperty.FIGHT_PROP_MAX_HP) * hpPercent);
        if (this.getPlayer() != null && this.getPlayer().hasSentAvatarDataNotify()) {
            this.getPlayer().sendPacket(new PacketAvatarFightPropNotify(this));
            EntityAvatar entity = this.getAsEntity();
            if (entity != null && (!this.getExtraAbilityEmbryos().equals(prevExtraAbilityEmbryos) || forceSendAbilityChange)) {
                this.getPlayer().sendPacket(new PacketAbilityChangeNotify(entity));
            }
        }
    }

    public void addToExtraAbilityEmbryos(String openConfig, boolean forceAdd) {
        if (openConfig == null || openConfig.length() == 0) {
            return;
        }
        OpenConfigEntry entry = GameData.getOpenConfigEntries().get(openConfig);
        if (entry == null) {
            if (forceAdd) {
                this.getExtraAbilityEmbryos().add(openConfig);
            }
            return;
        }
        if (entry.getAddAbilities() != null) {
            for (String ability : entry.getAddAbilities()) {
                this.getExtraAbilityEmbryos().add(ability);
            }
        }
    }

    public void recalcConstellations() {
        this.getProudSkillBonusMap().clear();
        this.getSkillExtraChargeMap().clear();
        if (this.getData() == null || this.getData().getSkillDepot() == null) {
            return;
        }
        if (this.getTalentIdList().size() > 0) {
            for (int talentId : this.getTalentIdList()) {
                AvatarSkillData skillData;
                OpenConfigEntry entry;
                AvatarTalentData avatarTalentData = (AvatarTalentData)GameData.getAvatarTalentDataMap().get(talentId);
                if (avatarTalentData == null || avatarTalentData.getOpenConfig() == null || avatarTalentData.getOpenConfig().length() == 0 || (entry = GameData.getOpenConfigEntries().get(avatarTalentData.getOpenConfig())) == null) continue;
                if (entry.getSkillPointModifiers() != null) {
                    for (OpenConfigEntry.SkillPointModifier mod : entry.getSkillPointModifiers()) {
                        AvatarSkillData skillData2 = (AvatarSkillData)GameData.getAvatarSkillDataMap().get(mod.getSkillId());
                        if (skillData2 == null) continue;
                        int charges = skillData2.getMaxChargeNum() + mod.getDelta();
                        this.getSkillExtraChargeMap().put(mod.getSkillId(), charges);
                    }
                    continue;
                }
                int skillId = 0;
                if (entry.getExtraTalentIndex() == 2 && this.getData().getSkillDepot().getSkills().size() >= 2) {
                    skillId = this.getData().getSkillDepot().getSkills().get(1);
                } else if (entry.getExtraTalentIndex() == 9) {
                    skillId = this.getData().getSkillDepot().getEnergySkill();
                }
                if (skillId == 0 || (skillData = (AvatarSkillData)GameData.getAvatarSkillDataMap().get(skillId)) == null) continue;
                this.getProudSkillBonusMap().put(skillData.getProudSkillGroupId(), 3);
            }
        }
    }

    public EntityAvatar getAsEntity() {
        for (EntityAvatar entity : this.getPlayer().getTeamManager().getActiveTeam()) {
            if (entity.getAvatar() != this) continue;
            return entity;
        }
        return null;
    }

    public int getEntityId() {
        EntityAvatar entity = this.getAsEntity();
        return entity != null ? entity.getId() : 0;
    }

    public void save() {
        DatabaseHelper.saveAvatar(this);
    }

    public AvatarInfoOuterClass.AvatarInfo toProto() {
        int fetterLevel = this.getFetterLevel();
        AvatarFetterInfoOuterClass.AvatarFetterInfo.Builder avatarFetter = AvatarFetterInfoOuterClass.AvatarFetterInfo.newBuilder().setExpLevel(fetterLevel);
        if (fetterLevel != 10) {
            avatarFetter.setExpNumber(this.getFetterExp());
        }
        if (this.getFetterList() != null) {
            for (int i2 = 0; i2 < this.getFetterList().size(); ++i2) {
                avatarFetter.addFetterList(FetterDataOuterClass.FetterData.newBuilder().setFetterId(this.getFetterList().get(i2)).setFetterState(FetterState.FINISH.getValue()));
            }
        }
        int cardId = this.getNameCardId();
        if (this.getPlayer().getNameCardList().contains(cardId)) {
            avatarFetter.addRewardedFetterLevelList(10);
        }
        AvatarInfoOuterClass.AvatarInfo.Builder avatarInfo = AvatarInfoOuterClass.AvatarInfo.newBuilder().setAvatarId(this.getAvatarId()).setGuid(this.getGuid()).setLifeState(1).addAllTalentIdList(this.getTalentIdList()).putAllFightPropMap(this.getFightProperties()).setSkillDepotId(this.getSkillDepotId()).setCoreProudSkillLevel(this.getCoreProudSkillLevel()).putAllSkillLevelMap(this.getSkillLevelMap()).addAllInherentProudSkillList(this.getProudSkillList()).putAllProudSkillExtraLevelMap(this.getProudSkillBonusMap()).setAvatarType(1).setBornTime(this.getBornTime()).setFetterInfo(avatarFetter).setWearingFlycloakId(this.getFlyCloak()).setCostumeId(this.getCostume());
        for (Map.Entry<Integer, Integer> entry : this.getSkillExtraChargeMap().entrySet()) {
            avatarInfo.putSkillMap(entry.getKey(), AvatarSkillInfoOuterClass.AvatarSkillInfo.newBuilder().setMaxChargeCount(entry.getValue()).build());
        }
        for (GameItem item : this.getEquips().values()) {
            avatarInfo.addEquipGuidList(item.getGuid());
        }
        avatarInfo.putPropMap(PlayerProperty.PROP_LEVEL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, this.getLevel()));
        avatarInfo.putPropMap(PlayerProperty.PROP_EXP.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_EXP, this.getExp()));
        avatarInfo.putPropMap(PlayerProperty.PROP_BREAK_LEVEL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_BREAK_LEVEL, this.getPromoteLevel()));
        avatarInfo.putPropMap(PlayerProperty.PROP_SATIATION_VAL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_SATIATION_VAL, 0));
        avatarInfo.putPropMap(PlayerProperty.PROP_SATIATION_PENALTY_TIME.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_SATIATION_PENALTY_TIME, 0));
        return avatarInfo.build();
    }

    public ShowAvatarInfoOuterClass.ShowAvatarInfo toShowAvatarInfoProto() {
        AvatarFetterInfoOuterClass.AvatarFetterInfo.Builder avatarFetter = AvatarFetterInfoOuterClass.AvatarFetterInfo.newBuilder().setExpLevel(this.getFetterLevel());
        ShowAvatarInfoOuterClass.ShowAvatarInfo.Builder showAvatarInfo = ShowAvatarInfoOuterClass.ShowAvatarInfo.newBuilder().setAvatarId(this.avatarId).addAllTalentIdList(this.getTalentIdList()).putAllFightPropMap(this.getFightProperties()).setSkillDepotId(this.getSkillDepotId()).setCoreProudSkillLevel(this.getCoreProudSkillLevel()).addAllInherentProudSkillList(this.getProudSkillList()).putAllSkillLevelMap(this.getSkillLevelMap()).putAllProudSkillExtraLevelMap(this.getProudSkillBonusMap()).setFetterInfo(avatarFetter).setCostumeId(this.getCostume());
        showAvatarInfo.putPropMap(PlayerProperty.PROP_LEVEL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, this.getLevel()));
        showAvatarInfo.putPropMap(PlayerProperty.PROP_EXP.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_EXP, this.getExp()));
        showAvatarInfo.putPropMap(PlayerProperty.PROP_BREAK_LEVEL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_BREAK_LEVEL, this.getPromoteLevel()));
        showAvatarInfo.putPropMap(PlayerProperty.PROP_SATIATION_VAL.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_SATIATION_VAL, this.getSatiation()));
        showAvatarInfo.putPropMap(PlayerProperty.PROP_SATIATION_PENALTY_TIME.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_SATIATION_VAL, this.getSatiationPenalty()));
        int maxStamina = this.getPlayer().getProperty(PlayerProperty.PROP_MAX_STAMINA);
        showAvatarInfo.putPropMap(PlayerProperty.PROP_MAX_STAMINA.getId(), ProtoHelper.newPropValue(PlayerProperty.PROP_MAX_STAMINA, maxStamina));
        for (GameItem item : this.getEquips().values()) {
            if (item.getItemType() == ItemType.ITEM_RELIQUARY) {
                showAvatarInfo.addEquipList(ShowEquipOuterClass.ShowEquip.newBuilder().setItemId(item.getItemId()).setReliquary(item.toReliquaryProto()));
                continue;
            }
            if (item.getItemType() != ItemType.ITEM_WEAPON) continue;
            showAvatarInfo.addEquipList(ShowEquipOuterClass.ShowEquip.newBuilder().setItemId(item.getItemId()).setWeapon(item.toWeaponProto()));
        }
        return showAvatarInfo.build();
    }

    @PostLoad
    private void onLoad() {
    }

    @PrePersist
    private void prePersist() {
        this.currentHp = this.getFightProperty(FightProperty.FIGHT_PROP_CUR_HP);
    }
}

