/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.database;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.query.experimental.filters.Filters;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseCounter;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.friends.Friendship;
import emu.grasscutter.game.gacha.GachaRecord;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;

public final class DatabaseManager {
    private static MongoClient mongoClient;
    private static MongoClient dispatchMongoClient;
    private static Datastore datastore;
    private static Datastore dispatchDatastore;
    private static final Class<?>[] mappedClasses;

    public static Datastore getDatastore() {
        return datastore;
    }

    public static MongoDatabase getDatabase() {
        return DatabaseManager.getDatastore().getDatabase();
    }

    public static Datastore getAccountDatastore() {
        if (Grasscutter.getConfig().RunMode == Grasscutter.ServerRunMode.GAME_ONLY) {
            return dispatchDatastore;
        }
        return datastore;
    }

    public static void initialize() {
        block8: {
            MongoIterable<String> collections;
            block7: {
                MongoClient mongoClient = MongoClients.create(Grasscutter.getConfig().DatabaseUrl);
                MapperOptions mapperOptions = MapperOptions.builder().storeEmpties(true).storeNulls(false).build();
                datastore = Morphia.createDatastore(mongoClient, Grasscutter.getConfig().DatabaseCollection, mapperOptions);
                datastore.getMapper().map(mappedClasses);
                try {
                    datastore.ensureIndexes();
                }
                catch (MongoCommandException exception) {
                    Grasscutter.getLogger().info("Mongo index error: ", exception);
                    if (exception.getCode() != 85) break block7;
                    collections = datastore.getDatabase().listCollectionNames();
                    for (String name : collections) {
                        datastore.getDatabase().getCollection(name).dropIndexes();
                    }
                    datastore.ensureIndexes();
                }
            }
            if (Grasscutter.getConfig().RunMode == Grasscutter.ServerRunMode.GAME_ONLY) {
                dispatchMongoClient = MongoClients.create(Grasscutter.getConfig().getGameServerOptions().DispatchServerDatabaseUrl);
                dispatchDatastore = Morphia.createDatastore(dispatchMongoClient, Grasscutter.getConfig().getGameServerOptions().DispatchServerDatabaseCollection);
                try {
                    dispatchDatastore.ensureIndexes();
                }
                catch (MongoCommandException e) {
                    Grasscutter.getLogger().info("Mongo index error: ", e);
                    if (e.getCode() != 85) break block8;
                    collections = dispatchDatastore.getDatabase().listCollectionNames();
                    for (String name : collections) {
                        dispatchDatastore.getDatabase().getCollection(name).dropIndexes();
                    }
                    dispatchDatastore.ensureIndexes();
                }
            }
        }
    }

    public static synchronized int getNextId(Class<?> c) {
        DatabaseCounter counter = DatabaseManager.getDatastore().find(DatabaseCounter.class).filter(Filters.eq("_id", c.getSimpleName())).first();
        if (counter == null) {
            counter = new DatabaseCounter(c.getSimpleName());
        }
        try {
            int n = counter.getNextId();
            return n;
        }
        finally {
            DatabaseManager.getDatastore().save(counter);
        }
    }

    public static synchronized int getNextId(Object o) {
        return DatabaseManager.getNextId(o.getClass());
    }

    static {
        mappedClasses = new Class[]{DatabaseCounter.class, Account.class, Player.class, Avatar.class, GameItem.class, Friendship.class, GachaRecord.class, Mail.class};
    }
}

