/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data.def;

import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceType;
import emu.grasscutter.data.common.FightPropData;
import emu.grasscutter.data.common.ItemParamData;
import java.util.ArrayList;

@ResourceType(name={"AvatarPromoteExcelConfigData.json"})
public class AvatarPromoteData
extends GameResource {
    private int AvatarPromoteId;
    private int PromoteLevel;
    private int ScoinCost;
    private ItemParamData[] CostItems;
    private int UnlockMaxLevel;
    private FightPropData[] AddProps;
    private int RequiredPlayerLevel;

    @Override
    public int getId() {
        return (this.AvatarPromoteId << 8) + this.PromoteLevel;
    }

    public int getAvatarPromoteId() {
        return this.AvatarPromoteId;
    }

    public int getPromoteLevel() {
        return this.PromoteLevel;
    }

    public ItemParamData[] getCostItems() {
        return this.CostItems;
    }

    public int getCoinCost() {
        return this.ScoinCost;
    }

    public FightPropData[] getAddProps() {
        return this.AddProps;
    }

    public int getUnlockMaxLevel() {
        return this.UnlockMaxLevel;
    }

    public int getRequiredPlayerLevel() {
        return this.RequiredPlayerLevel;
    }

    @Override
    public void onLoad() {
        ArrayList<ItemParamData> trim = new ArrayList<ItemParamData>(this.getAddProps().length);
        for (ItemParamData itemParam : this.getCostItems()) {
            if (itemParam.getId() == 0) continue;
            trim.add(itemParam);
        }
        this.CostItems = trim.toArray(new ItemParamData[trim.size()]);
        ArrayList<FightPropData> parsed = new ArrayList<FightPropData>(this.getAddProps().length);
        for (FightPropData prop : this.getAddProps()) {
            if (prop.getPropType() == null || prop.getValue() == 0.0f) continue;
            prop.onLoad();
            parsed.add(prop);
        }
        this.AddProps = parsed.toArray(new FightPropData[parsed.size()]);
    }
}

