/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.def.ReliquaryAffixData;
import emu.grasscutter.data.def.ReliquaryMainPropData;
import emu.grasscutter.game.world.SpawnDataEntry;
import emu.grasscutter.utils.WeightedList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.danilopianini.util.FlexibleQuadTree;
import org.danilopianini.util.SpatialIndex;

public class GameDepot {
    private static Int2ObjectMap<WeightedList<ReliquaryMainPropData>> relicMainPropDepot = new Int2ObjectOpenHashMap<WeightedList<ReliquaryMainPropData>>();
    private static Int2ObjectMap<List<ReliquaryAffixData>> relicAffixDepot = new Int2ObjectOpenHashMap<List<ReliquaryAffixData>>();
    private static Int2ObjectMap<SpatialIndex<SpawnDataEntry.SpawnGroupEntry>> spawnLists = new Int2ObjectOpenHashMap<SpatialIndex<SpawnDataEntry.SpawnGroupEntry>>();

    public static void load() {
        Object list;
        for (GameResource data : GameData.getReliquaryMainPropDataMap().values()) {
            if (((ReliquaryMainPropData)data).getWeight() <= 0 || ((ReliquaryMainPropData)data).getPropDepotId() <= 0) continue;
            list = relicMainPropDepot.computeIfAbsent(((ReliquaryMainPropData)data).getPropDepotId(), k -> new WeightedList());
            ((WeightedList)list).add(((ReliquaryMainPropData)data).getWeight(), data);
        }
        for (GameResource data : GameData.getReliquaryAffixDataMap().values()) {
            if (((ReliquaryAffixData)data).getWeight() <= 0 || ((ReliquaryAffixData)data).getDepotId() <= 0) continue;
            list = relicAffixDepot.computeIfAbsent(((ReliquaryAffixData)data).getDepotId(), k -> new ArrayList());
            list.add(data);
        }
        if (relicMainPropDepot.size() == 0 || relicAffixDepot.size() == 0) {
            Grasscutter.getLogger().error("Relic properties are missing weights! Please check your ReliquaryMainPropExcelConfigData or ReliquaryAffixExcelConfigData files in your ExcelBinOutput folder.");
        }
    }

    public static ReliquaryMainPropData getRandomRelicMainProp(int depot) {
        WeightedList depotList = (WeightedList)relicMainPropDepot.get(depot);
        if (depotList == null) {
            return null;
        }
        return (ReliquaryMainPropData)depotList.next();
    }

    public static List<ReliquaryAffixData> getRandomRelicAffixList(int depot) {
        return (List)relicAffixDepot.get(depot);
    }

    public static Int2ObjectMap<SpatialIndex<SpawnDataEntry.SpawnGroupEntry>> getSpawnLists() {
        return spawnLists;
    }

    public static SpatialIndex<SpawnDataEntry.SpawnGroupEntry> getSpawnListById(int sceneId) {
        return GameDepot.getSpawnLists().computeIfAbsent(sceneId, id -> new FlexibleQuadTree());
    }
}

