/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="teleport", usage="teleport [@player id] <x> <y> <z> [scene id]", aliases={"tp"}, description="Change the player's position.", permission="player.teleport")
public final class TeleportCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        int target;
        if (args2.size() < (sender == null ? 4 : 3)) {
            CommandHandler.sendMessage(sender, sender == null ? Grasscutter.getLanguage().Teleport_usage_server : Grasscutter.getLanguage().Teleport_usage);
            return;
        }
        if (args2.get(0).startsWith("@")) {
            try {
                target = Integer.parseInt(args2.get(0).substring(1));
            }
            catch (NumberFormatException e) {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_playerId);
                return;
            }
        } else {
            if (sender == null) {
                CommandHandler.sendMessage(null, Grasscutter.getLanguage().Teleport_specify_player_id);
                return;
            }
            target = sender.getUid();
        }
        Player targetPlayer = Grasscutter.getGameServer().getPlayerByUid(target);
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Player_not_found_or_offline);
            return;
        }
        args2 = args2.subList(args2.get(0).startsWith("@") ? 1 : 0, args2.size());
        try {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            x = args2.get(0).contains("~") ? (args2.get(0).equals("~") ? targetPlayer.getPos().getX() : Float.parseFloat(args2.get(0).replace("~", "")) + targetPlayer.getPos().getX()) : Float.parseFloat(args2.get(0));
            y = args2.get(1).contains("~") ? (args2.get(1).equals("~") ? targetPlayer.getPos().getY() : Float.parseFloat(args2.get(1).replace("~", "")) + targetPlayer.getPos().getY()) : Float.parseFloat(args2.get(1));
            z = args2.get(2).contains("~") ? (args2.get(2).equals("~") ? targetPlayer.getPos().getZ() : Float.parseFloat(args2.get(2).replace("~", "")) + targetPlayer.getPos().getZ()) : Float.parseFloat(args2.get(2));
            int sceneId = targetPlayer.getSceneId();
            if (args2.size() == 4) {
                sceneId = Integer.parseInt(args2.get(3));
            }
            Position target_pos = new Position(x, y, z);
            boolean result = targetPlayer.getWorld().transferPlayerToScene(targetPlayer, sceneId, target_pos);
            if (!result) {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Teleport_invalid_position);
            } else {
                CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Teleport_message, targetPlayer.getNickname(), Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), sceneId));
            }
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Teleport_invalid_position);
        }
    }
}

