/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.GadgetData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.entity.EntityVehicle;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="spawn", usage="spawn <entityId> [amount] [level(monster only)]", description="Spawns an entity near you", permission="server.spawn")
public final class SpawnCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        if (sender == null) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Run_this_command_in_game);
            return;
        }
        if (args2.size() < 1) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Spawn_usage);
            return;
        }
        try {
            int id = Integer.parseInt(args2.get(0));
            int amount = args2.size() > 1 ? Integer.parseInt(args2.get(1)) : 1;
            int level = args2.size() > 2 ? Integer.parseInt(args2.get(2)) : 1;
            MonsterData monsterData = (MonsterData)GameData.getMonsterDataMap().get(id);
            GadgetData gadgetData = (GadgetData)GameData.getGadgetDataMap().get(id);
            ItemData itemData = (ItemData)GameData.getItemDataMap().get(id);
            if (monsterData == null && gadgetData == null && itemData == null) {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_entity_id);
                return;
            }
            double maxRadius = Math.sqrt((double)amount * 0.2 / Math.PI);
            for (int i2 = 0; i2 < amount; ++i2) {
                Position pos = this.GetRandomPositionInCircle(sender.getPos(), maxRadius).addY(3.0f);
                GameEntity entity = null;
                if (itemData != null) {
                    entity = new EntityItem(sender.getScene(), null, itemData, pos, 1, true);
                }
                if (gadgetData != null) {
                    entity = new EntityVehicle(sender.getScene(), sender.getSession().getPlayer(), gadgetData.getId(), 0, pos, sender.getRotation());
                    int gadgetId = gadgetData.getId();
                    switch (gadgetId) {
                        case 45001001: 
                        case 45001002: {
                            entity.addFightProperty(FightProperty.FIGHT_PROP_BASE_HP, 10000.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK, 100.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, 100.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_HP, 10000.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, 0.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_SPEED, 0.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY, 0.0f);
                            entity.addFightProperty(FightProperty.FIGHT_PROP_MAX_HP, 10000.0f);
                            break;
                        }
                    }
                }
                if (monsterData != null) {
                    entity = new EntityMonster(sender.getScene(), monsterData, pos, level);
                }
                sender.getScene().addEntity(entity);
            }
            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Spawn_message, amount, id));
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_entity_id);
        }
    }

    private Position GetRandomPositionInCircle(Position origin, double radius) {
        Position target = origin.clone();
        double angle = Math.random() * 360.0;
        double r = Math.sqrt(Math.random() * radius * radius);
        target.addX((float)(r * Math.cos(angle))).addZ((float)(r * Math.sin(angle)));
        return target;
    }
}

