/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.server.packet.send.PacketEntityFightPropUpdateNotify;
import java.util.List;

@Command(label="setstats", usage="setstats|stats <stat> <value>", description="Set fight property for your current active character", aliases={"stats"}, permission="player.setstats")
public final class SetStatsCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        String stat;
        if (sender == null) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Run_this_command_in_game);
            return;
        }
        if (args2.size() < 2) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_usage);
            return;
        }
        switch (stat = args2.get(0)) {
            default: {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_setstats_help_message);
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_stats_help_message);
                return;
            }
            case "mhp": {
                try {
                    int health = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    entity.setFightProperty(FightProperty.FIGHT_PROP_MAX_HP, health);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_MAX_HP));
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_max_hp, health));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_max_hp_error);
                    return;
                }
            }
            case "hp": {
                try {
                    int health = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, health);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_HP));
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_hp, health));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_hp_error);
                    return;
                }
            }
            case "def": {
                try {
                    int def = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, def);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_DEFENSE));
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_def, def));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_def_error);
                    return;
                }
            }
            case "atk": {
                try {
                    int atk = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, atk);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_ATTACK));
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_atk, atk));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_atk_error);
                    return;
                }
            }
            case "em": {
                try {
                    int em = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    entity.setFightProperty(FightProperty.FIGHT_PROP_ELEMENT_MASTERY, em);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_ELEMENT_MASTERY));
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_em, em));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_em_error);
                    return;
                }
            }
            case "er": {
                try {
                    float er = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float erecharge = er / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY, erecharge);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY));
                    float iger = erecharge * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_er, Float.valueOf(iger)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_er_error);
                    return;
                }
            }
            case "crate": {
                try {
                    float cr = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float crate = cr / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CRITICAL, crate);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CRITICAL));
                    float igcrate = crate * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_cr, Float.valueOf(igcrate)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_cr_error);
                    return;
                }
            }
            case "cdmg": {
                try {
                    float cdmg = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float cdamage = cdmg / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_CRITICAL_HURT, cdamage);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CRITICAL_HURT));
                    float igcdmg = cdamage * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_cd, Float.valueOf(igcdmg)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_cd_error);
                    return;
                }
            }
            case "epyro": {
                try {
                    float epyro = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float pyro = epyro / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_FIRE_ADD_HURT, pyro);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_FIRE_ADD_HURT));
                    float igpyro = pyro * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_pdb, Float.valueOf(igpyro)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_pdb_error);
                    return;
                }
            }
            case "ecryo": {
                try {
                    float ecryo = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float cryo = ecryo / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_ICE_ADD_HURT, cryo);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_ICE_ADD_HURT));
                    float igcyro = cryo * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_cdb, Float.valueOf(igcyro)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_cdb_error);
                    return;
                }
            }
            case "ehydro": {
                try {
                    float ehydro = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float hydro = ehydro / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_WATER_ADD_HURT, hydro);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_WATER_ADD_HURT));
                    float ighydro = hydro * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_hdb, Float.valueOf(ighydro)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_hdb_error);
                    return;
                }
            }
            case "eanemo": {
                try {
                    float eanemo = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float anemo = eanemo / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_WIND_ADD_HURT, anemo);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_WIND_ADD_HURT));
                    float iganemo = anemo * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_adb, Float.valueOf(iganemo)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_adb_error);
                    return;
                }
            }
            case "egeo": {
                try {
                    float egeo = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float geo = egeo / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_ROCK_ADD_HURT, geo);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_ROCK_ADD_HURT));
                    float iggeo = geo * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_gdb, Float.valueOf(iggeo)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_gdb_error);
                    return;
                }
            }
            case "ethunder": 
            case "eelec": {
                try {
                    float eelec = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float elec = eelec / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_ELEC_ADD_HURT, elec);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_ELEC_ADD_HURT));
                    float igelec = elec * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_edb, Float.valueOf(igelec)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_edb_error);
                    return;
                }
            }
            case "ephys": {
                try {
                    float ephys = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float phys = ephys / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_PHYSICAL_ADD_HURT, phys);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_PHYSICAL_ADD_HURT));
                    float igphys = phys * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_physdb, Float.valueOf(igphys)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_physdb_error);
                    return;
                }
            }
            case "edend": {
                try {
                    float edend = Integer.parseInt(args2.get(1));
                    EntityAvatar entity = sender.getTeamManager().getCurrentAvatarEntity();
                    float dend = edend / 10000.0f;
                    entity.setFightProperty(FightProperty.FIGHT_PROP_GRASS_ADD_HURT, dend);
                    entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_GRASS_ADD_HURT));
                    float igdend = dend * 100.0f;
                    CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SetStats_set_ddb, Float.valueOf(igdend)));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SetStats_set_ddb_error);
                    return;
                }
            }
        }
    }
}

