/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import java.util.HashMap;
import java.util.List;

@Command(label="sendmail", usage="sendmail <userId|all|help> [templateId]", description="Sends mail to the specified user. The usage of this command changes based on it's composition state.", permission="server.sendmail")
public final class SendMailCommand
implements CommandHandler {
    private static final HashMap<Integer, MailBuilder> mailBeingConstructed = new HashMap();

    @Override
    public void execute(Player sender, List<String> args2) {
        int senderId = sender != null ? sender.getUid() : -1;
        if (!mailBeingConstructed.containsKey(senderId)) {
            switch (args2.size()) {
                case 1: {
                    MailBuilder mailBuilder;
                    switch (args2.get(0).toLowerCase()) {
                        case "help": {
                            CommandHandler.sendMessage(sender, this.getClass().getAnnotation(Command.class).description() + "\nUsage: " + this.getClass().getAnnotation(Command.class).usage());
                            return;
                        }
                        case "all": {
                            mailBuilder = new MailBuilder(true, new Mail());
                            break;
                        }
                        default: {
                            if (DatabaseHelper.getPlayerById(Integer.parseInt(args2.get(0))) != null) {
                                mailBuilder = new MailBuilder(Integer.parseInt(args2.get(0)), new Mail());
                                break;
                            }
                            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_user_not_exist, args2.get(0)));
                            return;
                        }
                    }
                    mailBeingConstructed.put(senderId, mailBuilder);
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_start_composition);
                    break;
                }
                case 2: {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_templates);
                    break;
                }
                default: {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_invalid_arguments);
                    break;
                }
            }
        } else {
            MailBuilder mailBuilder = mailBeingConstructed.get(senderId);
            if (args2.size() >= 1) {
                switch (args2.get(0).toLowerCase()) {
                    case "stop": {
                        mailBeingConstructed.remove(senderId);
                        CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_send_cancel);
                        return;
                    }
                    case "finish": {
                        if (mailBuilder.constructionStage == 3) {
                            if (!mailBuilder.sendToAll) {
                                Grasscutter.getGameServer().getPlayerByUid(mailBuilder.recipient, true).sendMail(mailBuilder.mail);
                                CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_send_done, mailBuilder.recipient));
                            } else {
                                for (Player player : DatabaseHelper.getAllPlayers()) {
                                    Grasscutter.getGameServer().getPlayerByUid(player.getUid(), true).sendMail(mailBuilder.mail);
                                }
                                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_send_all_done);
                            }
                            mailBeingConstructed.remove(senderId);
                        } else {
                            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_not_composition_end, this.getConstructionArgs(mailBuilder.constructionStage)));
                        }
                        return;
                    }
                    case "help": {
                        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_Please_use, this.getConstructionArgs(mailBuilder.constructionStage)));
                        return;
                    }
                }
                switch (mailBuilder.constructionStage) {
                    case 0: {
                        String title;
                        mailBuilder.mail.mailContent.title = title = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_set_title, title));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 1: {
                        String contents;
                        mailBuilder.mail.mailContent.content = contents = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_set_contents, contents));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 2: {
                        String msgSender;
                        mailBuilder.mail.mailContent.sender = msgSender = String.join((CharSequence)" ", args2.subList(0, args2.size()));
                        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_set_message_sender, msgSender));
                        ++mailBuilder.constructionStage;
                        break;
                    }
                    case 3: {
                        int lvl;
                        int item;
                        int amount = 1;
                        switch (args2.size()) {
                            default: {
                                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().SendMail_usage);
                                return;
                            }
                            case 1: {
                                try {
                                    item = Integer.parseInt(args2.get(0));
                                    lvl = 1;
                                    break;
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_id);
                                    return;
                                }
                            }
                            case 2: {
                                lvl = 1;
                                item = Integer.parseInt(args2.get(0));
                                amount = Integer.parseInt(args2.get(1));
                                break;
                            }
                            case 3: {
                                try {
                                    item = Integer.parseInt(args2.get(0));
                                    amount = Integer.parseInt(args2.get(1));
                                    lvl = Integer.parseInt(args2.get(2));
                                    break;
                                }
                                catch (NumberFormatException ignored) {
                                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
                                    return;
                                }
                            }
                        }
                        mailBuilder.mail.itemList.add(new Mail.MailItem(item, amount, lvl));
                        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_send, amount, item, lvl));
                    }
                }
            } else {
                CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().SendMail_invalid_arguments_please_use, this.getConstructionArgs(mailBuilder.constructionStage)));
            }
        }
    }

    private String getConstructionArgs(int stage) {
        switch (stage) {
            case 0: {
                return Grasscutter.getLanguage().SendMail_title;
            }
            case 1: {
                return Grasscutter.getLanguage().SendMail_message;
            }
            case 2: {
                return Grasscutter.getLanguage().SendMail_sender;
            }
            case 3: {
                return Grasscutter.getLanguage().SendMail_arguments;
            }
        }
        Thread.dumpStack();
        return String.format(Grasscutter.getLanguage().SendMail_error, stage);
    }

    public static class MailBuilder {
        public int recipient;
        public boolean sendToAll;
        public int constructionStage;
        public Mail mail;

        public MailBuilder(int recipient, Mail mail) {
            this.recipient = recipient;
            this.sendToAll = false;
            this.constructionStage = 0;
            this.mail = mail;
        }

        public MailBuilder(boolean sendToAll, Mail mail) {
            if (sendToAll) {
                this.recipient = 0;
                this.sendToAll = true;
                this.constructionStage = 0;
                this.mail = mail;
            } else {
                Grasscutter.getLogger().error("Please use MailBuilder(int, mail) when not sending to all");
                Thread.dumpStack();
            }
        }
    }
}

