/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import java.util.LinkedList;
import java.util.List;

@Command(label="give", usage="give [player] <itemId|itemName> [amount] [level]", description="Gives an item to you or the specified player", aliases={"g", "item", "giveitem"}, permission="player.give")
public final class GiveCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        int lvl;
        int target;
        int item;
        int amount = 1;
        int refinement = 0;
        if (sender == null && args2.size() < 2) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Give_usage);
            return;
        }
        switch (args2.size()) {
            default: {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Give_usage);
                return;
            }
            case 1: {
                try {
                    item = Integer.parseInt(args2.get(0));
                    target = sender.getUid();
                    lvl = 1;
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_id);
                    return;
                }
            }
            case 2: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    lvl = 1;
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null && sender != null) {
                        target = sender.getUid();
                        item = Integer.parseInt(args2.get(0));
                        amount = Integer.parseInt(args2.get(1));
                        break;
                    }
                    item = Integer.parseInt(args2.get(1));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
                    return;
                }
            }
            case 3: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null && sender != null) {
                        target = sender.getUid();
                        item = Integer.parseInt(args2.get(0));
                        amount = Integer.parseInt(args2.get(1));
                        lvl = Integer.parseInt(args2.get(2));
                        break;
                    }
                    item = Integer.parseInt(args2.get(1));
                    amount = Integer.parseInt(args2.get(2));
                    lvl = 1;
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
                    return;
                }
            }
            case 4: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null && sender != null) {
                        target = sender.getUid();
                        item = Integer.parseInt(args2.get(0));
                        amount = Integer.parseInt(args2.get(1));
                        lvl = Integer.parseInt(args2.get(2));
                        refinement = Integer.parseInt(args2.get(3));
                        break;
                    }
                    item = Integer.parseInt(args2.get(1));
                    amount = Integer.parseInt(args2.get(2));
                    lvl = Integer.parseInt(args2.get(3));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
                    return;
                }
            }
            case 5: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null) {
                        CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_playerId);
                        return;
                    }
                    item = Integer.parseInt(args2.get(1));
                    amount = Integer.parseInt(args2.get(2));
                    lvl = Integer.parseInt(args2.get(3));
                    refinement = Integer.parseInt(args2.get(4));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
                    return;
                }
            }
        }
        Player targetPlayer = Grasscutter.getGameServer().getPlayerByUid(target);
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Player_not_found);
            return;
        }
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(item);
        if (itemData == null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_id);
            return;
        }
        if (refinement != 0) {
            if (itemData.getItemType() == ItemType.ITEM_WEAPON) {
                if (refinement < 1 || refinement > 5) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Give_refinement_must_between_1_and_5);
                    return;
                }
            } else {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Give_refinement_only_applicable_weapons);
                return;
            }
        }
        this.item(targetPlayer, itemData, amount, lvl, refinement);
        if (!itemData.isEquip()) {
            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Give_given, amount, item, target));
        } else if (itemData.getItemType() == ItemType.ITEM_WEAPON) {
            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Give_given_with_level_and_refinement, item, lvl, refinement, amount, target));
        } else {
            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Give_given_level, item, lvl, amount, target));
        }
    }

    private void item(Player player, ItemData itemData, int amount, int lvl, int refinement) {
        if (itemData.isEquip()) {
            LinkedList<GameItem> items = new LinkedList<GameItem>();
            for (int i2 = 0; i2 < amount; ++i2) {
                GameItem item = new GameItem(itemData);
                if (item.isEquipped()) {
                    if (item.getItemType() == ItemType.ITEM_WEAPON) {
                        if (lvl > 90) {
                            lvl = 90;
                        }
                    } else if (lvl > 21) {
                        lvl = 21;
                    }
                }
                item.setCount(amount);
                item.setLevel(lvl);
                if (lvl > 80) {
                    item.setPromoteLevel(6);
                } else if (lvl > 70) {
                    item.setPromoteLevel(5);
                } else if (lvl > 60) {
                    item.setPromoteLevel(4);
                } else if (lvl > 50) {
                    item.setPromoteLevel(3);
                } else if (lvl > 40) {
                    item.setPromoteLevel(2);
                } else if (lvl > 20) {
                    item.setPromoteLevel(1);
                }
                if (item.getItemType() == ItemType.ITEM_WEAPON) {
                    if (refinement > 0) {
                        item.setRefinement(refinement - 1);
                    } else {
                        item.setRefinement(0);
                    }
                }
                items.add(item);
            }
            player.getInventory().addItems(items, ActionReason.SubfieldDrop);
        } else {
            GameItem item = new GameItem(itemData);
            item.setCount(amount);
            player.getInventory().addItem(item, ActionReason.SubfieldDrop);
        }
    }
}

