/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.player.Player;
import java.util.List;

@Command(label="givechar", usage="givechar <playerId> <avatarId> [level]", description="Gives the player a specified character", aliases={"givec"}, permission="player.givechar")
public final class GiveCharCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        int avatarId;
        int target;
        int level = 1;
        if (sender == null && args2.size() < 2) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().GiveChar_usage);
            return;
        }
        switch (args2.size()) {
            default: {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().GiveChar_usage);
                return;
            }
            case 2: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null && sender != null) {
                        target = sender.getUid();
                        level = Integer.parseInt(args2.get(1));
                        avatarId = Integer.parseInt(args2.get(0));
                        break;
                    }
                    avatarId = Integer.parseInt(args2.get(1));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().GiveChar_invalid_avatar_or_player_id);
                    return;
                }
            }
            case 3: {
                try {
                    target = Integer.parseInt(args2.get(0));
                    if (Grasscutter.getGameServer().getPlayerByUid(target) == null) {
                        CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_playerId);
                        return;
                    }
                    avatarId = Integer.parseInt(args2.get(1));
                    level = Integer.parseInt(args2.get(2));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Grasscutter.getLanguage().GiveChar_invalid_avatar_or_player_id);
                    return;
                }
            }
        }
        Player targetPlayer = Grasscutter.getGameServer().getPlayerByUid(target);
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Player_not_found);
            return;
        }
        AvatarData avatarData = (AvatarData)GameData.getAvatarDataMap().get(avatarId);
        if (avatarData == null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().GiveChar_invalid_avatar_id);
            return;
        }
        if (level > 90) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().GiveChar_invalid_avatar_level);
            return;
        }
        int ascension = level <= 40 ? (int)Math.ceil((float)level / 20.0f) : (int)Math.ceil((float)level / 10.0f) - 3;
        Avatar avatar = new Avatar(avatarId);
        avatar.setLevel(level);
        avatar.setPromoteLevel(ascension);
        avatar.recalcStats();
        targetPlayer.addAvatar(avatar);
        CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().GiveChar_given, avatarId, level, target));
    }
}

