/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="drop", usage="drop <itemId|itemName> [amount]", description="Drops an item near you", aliases={"d", "dropitem"}, permission="server.drop")
public final class DropCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        if (sender == null) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Run_this_command_in_game);
            return;
        }
        if (args2.size() < 1) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Drop_usage);
            return;
        }
        try {
            ItemData itemData;
            int item = Integer.parseInt(args2.get(0));
            int amount = 1;
            if (args2.size() > 1) {
                amount = Integer.parseInt(args2.get(1));
            }
            if ((itemData = (ItemData)GameData.getItemDataMap().get(item)) == null) {
                CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_id);
                return;
            }
            if (itemData.isEquip()) {
                float range = 5.0f + 0.1f * (float)amount;
                for (int i2 = 0; i2 < amount; ++i2) {
                    Position pos = sender.getPos().clone().addX((float)(Math.random() * (double)range) - range / 2.0f).addY(3.0f).addZ((float)(Math.random() * (double)range) - range / 2.0f);
                    EntityItem entity = new EntityItem(sender.getScene(), sender, itemData, pos, 1);
                    sender.getScene().addEntity(entity);
                }
            } else {
                EntityItem entity = new EntityItem(sender.getScene(), sender, itemData, sender.getPos().clone().addY(3.0f), amount);
                sender.getScene().addEntity(entity);
            }
            CommandHandler.sendMessage(sender, String.format(Grasscutter.getLanguage().Drop_dropped_of, amount, item));
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().Invalid_item_or_player_id);
        }
    }
}

