/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import java.util.List;

@Command(label="account", usage="account <create|delete> <username> [uid]", description="Modify user accounts")
public final class AccountCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, List<String> args2) {
        if (sender != null) {
            CommandHandler.sendMessage(sender, Grasscutter.getLanguage().This_command_can_only_run_from_console);
            return;
        }
        if (args2.size() < 2) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Account_command_usage);
            return;
        }
        String action = args2.get(0);
        String username = args2.get(1);
        switch (action) {
            default: {
                CommandHandler.sendMessage(null, Grasscutter.getLanguage().Account_command_usage);
                return;
            }
            case "create": {
                Account account;
                int uid = 0;
                if (args2.size() > 2) {
                    try {
                        uid = Integer.parseInt(args2.get(2));
                    }
                    catch (NumberFormatException ignored) {
                        CommandHandler.sendMessage(null, Grasscutter.getLanguage().Invalid_UID);
                        return;
                    }
                }
                if ((account = DatabaseHelper.createAccountWithId(username, uid)) == null) {
                    CommandHandler.sendMessage(null, Grasscutter.getLanguage().Account_exists);
                    return;
                }
                account.addPermission("*");
                account.save();
                CommandHandler.sendMessage(null, String.format(Grasscutter.getLanguage().Account_create_UID, account.getPlayerUid()));
                return;
            }
            case "delete": 
        }
        if (DatabaseHelper.deleteAccount(username)) {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Account_delete);
        } else {
            CommandHandler.sendMessage(null, Grasscutter.getLanguage().Account_not_find);
        }
    }
}

