/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public final class CommandMap {
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private final Map<String, Command> annotations = new HashMap<String, Command>();

    public CommandMap() {
        this(false);
    }

    public CommandMap(boolean scan2) {
        if (scan2) {
            this.scan();
        }
    }

    public static CommandMap getInstance() {
        return Grasscutter.getGameServer().getCommandMap();
    }

    public CommandMap registerCommand(String label, CommandHandler command) {
        Grasscutter.getLogger().debug("Registered command: " + label);
        Command annotation = command.getClass().getAnnotation(Command.class);
        this.annotations.put(label, annotation);
        this.commands.put(label, command);
        if (annotation.aliases().length > 0) {
            for (String alias : annotation.aliases()) {
                this.commands.put(alias, command);
                this.annotations.put(alias, annotation);
            }
        }
        return this;
    }

    public CommandMap unregisterCommand(String label) {
        Grasscutter.getLogger().debug("Unregistered command: " + label);
        CommandHandler handler = this.commands.get(label);
        if (handler == null) {
            return this;
        }
        Command annotation = handler.getClass().getAnnotation(Command.class);
        this.annotations.remove(label);
        this.commands.remove(label);
        if (annotation.aliases().length > 0) {
            for (String alias : annotation.aliases()) {
                this.commands.remove(alias);
                this.annotations.remove(alias);
            }
        }
        return this;
    }

    public List<CommandHandler> getHandlersAsList() {
        return new LinkedList<CommandHandler>(this.commands.values());
    }

    public HashMap<String, CommandHandler> getHandlers() {
        return new LinkedHashMap<String, CommandHandler>(this.commands);
    }

    public CommandHandler getHandler(String label) {
        return this.commands.get(label);
    }

    public void invoke(Player player, String rawMessage) {
        String[] split;
        LinkedList<String> args2;
        String label;
        CommandHandler handler;
        if ((rawMessage = rawMessage.trim()).length() == 0) {
            CommandHandler.sendMessage(player, Grasscutter.getLanguage().No_command_specified);
            return;
        }
        if (!Character.isLetter(rawMessage.charAt(0))) {
            rawMessage = rawMessage.substring(1);
        }
        if ((handler = this.commands.get(label = (String)(args2 = new LinkedList<String>(Arrays.asList(split = rawMessage.split(" ")))).remove(0))) == null) {
            CommandHandler.sendMessage(player, Grasscutter.getLanguage().Unknown_command + label);
            return;
        }
        if (player != null) {
            String permissionNode = this.annotations.get(label).permission();
            Account account = player.getAccount();
            if (!permissionNode.isEmpty() && !account.hasPermission(permissionNode)) {
                CommandHandler.sendMessage(player, Grasscutter.getLanguage().You_not_permission_run_command);
                return;
            }
        }
        boolean threading = this.annotations.get(label).threading();
        Runnable runnable = () -> handler.execute(player, args2);
        if (threading) {
            Thread command = new Thread(runnable);
            command.start();
        } else {
            runnable.run();
        }
    }

    private void scan() {
        Reflections reflector = Grasscutter.reflector;
        Set<Class<?>> classes = reflector.getTypesAnnotatedWith(Command.class);
        classes.forEach(annotated -> {
            try {
                Command cmdData = annotated.getAnnotation(Command.class);
                Object object = annotated.newInstance();
                if (object instanceof CommandHandler) {
                    this.registerCommand(cmdData.label(), (CommandHandler)object);
                } else {
                    Grasscutter.getLogger().error("Class " + annotated.getName() + " is not a CommandHandler!");
                }
            }
            catch (Exception exception) {
                Grasscutter.getLogger().error("Failed to register command handler for " + annotated.getSimpleName(), exception);
            }
        });
    }
}

