/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter;

import ch.qos.logback.classic.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import emu.grasscutter.Config;
import emu.grasscutter.Language;
import emu.grasscutter.command.CommandMap;
import emu.grasscutter.data.ResourceLoader;
import emu.grasscutter.database.DatabaseManager;
import emu.grasscutter.plugin.PluginManager;
import emu.grasscutter.plugin.api.ServerHook;
import emu.grasscutter.scripts.ScriptLoader;
import emu.grasscutter.server.dispatch.DispatchServer;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.tools.Tools;
import emu.grasscutter.utils.Crypto;
import emu.grasscutter.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOError;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.util.Calendar;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.LoggerFactory;

public final class Grasscutter {
    private static final Logger log = (Logger)LoggerFactory.getLogger(Grasscutter.class);
    private static Config config;
    private static LineReader consoleLineReader;
    private static Language language;
    private static final Gson gson;
    private static final File configFile;
    private static int day;
    private static DispatchServer dispatchServer;
    private static GameServer gameServer;
    private static PluginManager pluginManager;
    public static final Reflections reflector;

    public static void main(String[] args2) throws Exception {
        Crypto.loadKeys();
        for (String arg : args2) {
            switch (arg.toLowerCase()) {
                case "-handbook": {
                    Tools.createGmHandbook();
                    return;
                }
                case "-gachamap": {
                    Tools.createGachaMapping();
                    return;
                }
            }
        }
        Grasscutter.getLogger().info(Grasscutter.language.Starting_Grasscutter);
        Grasscutter.updateDayOfWeek();
        ResourceLoader.loadAll();
        ScriptLoader.init();
        DatabaseManager.initialize();
        pluginManager = new PluginManager();
        dispatchServer = new DispatchServer();
        gameServer = new GameServer(new InetSocketAddress(Grasscutter.getConfig().getGameServerOptions().Ip, Grasscutter.getConfig().getGameServerOptions().Port));
        new ServerHook(gameServer, dispatchServer);
        if (Grasscutter.getConfig().RunMode == ServerRunMode.HYBRID) {
            dispatchServer.start();
            gameServer.start();
        } else if (Grasscutter.getConfig().RunMode == ServerRunMode.DISPATCH_ONLY) {
            dispatchServer.start();
        } else if (Grasscutter.getConfig().RunMode == ServerRunMode.GAME_ONLY) {
            gameServer.start();
        } else {
            Grasscutter.getLogger().error(Grasscutter.language.Invalid_server_run_mode + " " + Grasscutter.getConfig().RunMode);
            Grasscutter.getLogger().error(Grasscutter.language.Server_run_mode);
            Grasscutter.getLogger().error(Grasscutter.language.Shutting_down);
            System.exit(1);
        }
        pluginManager.enablePlugins();
        Runtime.getRuntime().addShutdownHook(new Thread(Grasscutter::onShutdown));
        Grasscutter.startConsole();
    }

    private static void onShutdown() {
        pluginManager.disablePlugins();
    }

    public static void loadConfig() {
        try (FileReader file = new FileReader(configFile);){
            config = gson.fromJson((Reader)file, Config.class);
            Grasscutter.saveConfig();
        }
        catch (Exception e) {
            config = new Config();
            Grasscutter.saveConfig();
        }
    }

    public static void loadLanguage() {
        try (FileReader file = new FileReader(String.format(Grasscutter.getConfig().LANGUAGE_FOLDER + "%s.json", Grasscutter.config.Language));){
            language = gson.fromJson((Reader)file, Language.class);
        }
        catch (Exception e) {
            language = new Language();
            Grasscutter.config.Language = "en_us";
            Grasscutter.saveConfig();
            try {
                File folder = new File("./language");
                if (!folder.exists() && !folder.isDirectory()) {
                    folder.mkdirs();
                }
            }
            catch (Exception ee) {
                Grasscutter.getLogger().error("Unable to create language folder.");
            }
            try (FileWriter file2 = new FileWriter("./language/en_us.json");){
                file2.write(gson.toJson(language));
            }
            catch (Exception ee) {
                Grasscutter.getLogger().error("Unable to create language file.");
            }
        }
    }

    public static void saveConfig() {
        try (FileWriter file = new FileWriter(configFile);){
            file.write(gson.toJson(config));
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to save config file.");
        }
    }

    public static void startConsole() {
        if (Grasscutter.getConfig().RunMode == ServerRunMode.DISPATCH_ONLY) {
            Grasscutter.getLogger().info(Grasscutter.language.Dispatch_mode_not_support_command);
            return;
        }
        Grasscutter.getLogger().info(Grasscutter.language.Start_done);
        String input = null;
        boolean isLastInterrupted = false;
        while (true) {
            try {
                input = consoleLineReader.readLine("> ");
            }
            catch (UserInterruptException e) {
                if (!isLastInterrupted) {
                    isLastInterrupted = true;
                    Grasscutter.getLogger().info("Press Ctrl-C again to shutdown.");
                    continue;
                }
                Runtime.getRuntime().exit(0);
            }
            catch (EndOfFileException e) {
                Grasscutter.getLogger().info("EOF detected.");
                continue;
            }
            catch (IOError e) {
                Grasscutter.getLogger().error("An IO error occurred.", e);
                continue;
            }
            isLastInterrupted = false;
            try {
                CommandMap.getInstance().invoke(null, input);
                continue;
            }
            catch (Exception e) {
                Grasscutter.getLogger().error(Grasscutter.language.Command_error, e);
                continue;
            }
            break;
        }
    }

    public static Config getConfig() {
        return config;
    }

    public static Language getLanguage() {
        return language;
    }

    public static Logger getLogger() {
        return log;
    }

    public static LineReader getConsole() {
        if (consoleLineReader == null) {
            Terminal terminal = null;
            try {
                terminal = TerminalBuilder.builder().jna(true).build();
            }
            catch (Exception e) {
                try {
                    terminal = TerminalBuilder.builder().dumb(true).build();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            consoleLineReader = LineReaderBuilder.builder().terminal(terminal).build();
        }
        return consoleLineReader;
    }

    public static Gson getGsonFactory() {
        return gson;
    }

    public static DispatchServer getDispatchServer() {
        return dispatchServer;
    }

    public static GameServer getGameServer() {
        return gameServer;
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }

    public static void updateDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        day = calendar.get(7);
    }

    public static int getCurrentDayOfWeek() {
        return day;
    }

    static {
        consoleLineReader = null;
        gson = new GsonBuilder().setPrettyPrinting().create();
        configFile = new File("./config.json");
        reflector = new Reflections("emu.grasscutter", new Scanner[0]);
        System.setProperty("logback.configurationFile", "src/main/resources/logback.xml");
        Grasscutter.loadConfig();
        Grasscutter.loadLanguage();
        Utils.startupCheck();
    }

    public static enum ServerRunMode {
        HYBRID,
        DISPATCH_ONLY,
        GAME_ONLY;

    }

    public static enum ServerDebugMode {
        ALL,
        MISSING,
        NONE;

    }
}

