/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.updates;

import dev.morphia.internal.PathTarget;
import dev.morphia.query.OperationTarget;
import dev.morphia.query.Sort;
import dev.morphia.query.UpdateException;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import org.bson.Document;

public class PushOperator
extends UpdateOperator {
    private Integer position;
    private Integer slice;
    private Integer sort;
    private Document sortDocument;

    PushOperator(String field, List<?> values2) {
        super("$push", field, values2);
    }

    public PushOperator position(int position) {
        if (position < 0) {
            throw new UpdateException("The position must be at least 0.");
        }
        this.position = position;
        return this;
    }

    public PushOperator slice(int slice) {
        this.slice = slice;
        return this;
    }

    public PushOperator sort(int sort2) {
        if (this.sortDocument != null) {
            throw new IllegalStateException(Sofia.updateSortOptions("Sort", "sort document", new Locale[0]));
        }
        this.sort = sort2;
        return this;
    }

    public PushOperator sort(Sort value) {
        if (this.sort != null) {
            throw new IllegalStateException(Sofia.updateSortOptions("Sort document", "sort", new Locale[0]));
        }
        if (this.sortDocument == null) {
            this.sortDocument = new Document();
        }
        this.sortDocument.put(value.getField(), (Object)value.getOrder());
        return this;
    }

    @Override
    public OperationTarget toTarget(PathTarget pathTarget) {
        Document document = new Document("$each", this.value());
        if (this.position != null) {
            document.put("$position", (Object)this.position);
        }
        if (this.slice != null) {
            document.put("$slice", (Object)this.slice);
        }
        if (this.sort != null) {
            document.put("$sort", (Object)this.sort);
        }
        if (this.sortDocument != null) {
            document.put("$sort", (Object)this.sortDocument);
        }
        return new OperationTarget(pathTarget, document);
    }
}

