/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import java.util.regex.Pattern;
import org.bson.BsonRegularExpression;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class RegexFilter
extends Filter {
    private String regex;
    private String options;

    RegexFilter(String field) {
        super("$regex", field, null);
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(mapper));
        if (this.isNot()) {
            writer.writeStartDocument("$not");
        }
        ExpressionHelper.value(mapper, writer, "$regex", new BsonRegularExpression(this.regex), context);
        ExpressionHelper.value(mapper, writer, "$options", this.options, context);
        if (this.isNot()) {
            writer.writeEndDocument();
        }
        writer.writeEndDocument();
    }

    public RegexFilter options(String options) {
        this.options = options;
        return this;
    }

    public RegexFilter pattern(String pattern) {
        this.regex = pattern;
        return this;
    }

    public RegexFilter pattern(Pattern pattern) {
        this.regex = pattern.pattern();
        return this;
    }

    public RegexFilter caseInsensitive() {
        this.add("i");
        return this;
    }

    public RegexFilter extended() {
        this.add("x");
        return this;
    }

    public RegexFilter multiline() {
        this.add("m");
        return this;
    }

    public RegexFilter special() {
        this.add("s");
        return this;
    }

    private void add(String option) {
        if (this.options == null) {
            this.options = "";
        }
        if (!this.options.contains(option)) {
            this.options = this.options + option;
        }
    }
}

