/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class LogicalFilter
extends Filter {
    private final List<Filter> filters;

    LogicalFilter(String name, Filter ... filters) {
        super(name);
        this.filters = Arrays.asList(filters);
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartArray(this.getName());
        for (Filter filter : this.filters) {
            ExpressionHelper.document(writer, () -> filter.encode(mapper, writer, context));
        }
        writer.writeEndArray();
    }

    @Override
    public Filter entityType(Class<?> type2) {
        super.entityType(type2);
        for (Filter filter : this.filters) {
            filter.entityType(type2);
        }
        return this;
    }

    @Override
    public Filter isValidating(boolean validate) {
        super.isValidating(validate);
        for (Filter filter : this.filters) {
            filter.isValidating(validate);
        }
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getName(), this.filters);
    }
}

