/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.Type;
import dev.morphia.query.experimental.filters.Box;
import dev.morphia.query.experimental.filters.CenterFilter;
import dev.morphia.query.experimental.filters.ElemMatchFilter;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.GeoIntersectsFilter;
import dev.morphia.query.experimental.filters.GeoWithinFilter;
import dev.morphia.query.experimental.filters.LogicalFilter;
import dev.morphia.query.experimental.filters.NearFilter;
import dev.morphia.query.experimental.filters.PolygonFilter;
import dev.morphia.query.experimental.filters.RegexFilter;
import dev.morphia.query.experimental.filters.TextSearchFilter;
import java.util.Arrays;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;

public final class Filters {
    private Filters() {
    }

    public static Filter all(String field, Object val) {
        return new Filter("$all", field, val);
    }

    public static Filter and(Filter ... filters) {
        return new LogicalFilter("$and", filters);
    }

    public static Filter bitsAllClear(String field, int[] positions) {
        return new Filter("$bitsAllClear", field, positions);
    }

    public static Filter bitsAllClear(String field, int bitMask) {
        return new Filter("$bitsAllClear", field, bitMask);
    }

    public static Filter bitsAllSet(String field, int bitMask) {
        return new Filter("$bitsAllSet", field, bitMask);
    }

    public static Filter bitsAllSet(String field, int[] positions) {
        return new Filter("$bitsAllSet", field, positions);
    }

    public static Filter bitsAnyClear(String field, Object val) {
        return new Filter("$bitsAnyClear", field, val);
    }

    public static Filter bitsAnySet(String field, Object val) {
        return new Filter("$bitsAnySet", field, val);
    }

    public static Filter box(String field, Point bottomLeft, Point upperRight) {
        return new Box(field, bottomLeft, upperRight);
    }

    public static Filter center(String field, Point center, double radius) {
        return new CenterFilter("$center", field, center, radius);
    }

    public static Filter centerSphere(String field, Point center, double radius) {
        return new CenterFilter("$centerSphere", field, center, radius);
    }

    public static Filter comment(String field, Object val) {
        return new Filter("$comment", field, val);
    }

    public static Filter elemMatch(String field, Filter ... filters) {
        return new ElemMatchFilter(field, Arrays.asList(filters));
    }

    public static Filter eq(String field, Object val) {
        return new Filter("$eq", field, val){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                if (this.isNot()) {
                    ExpressionHelper.document(writer, this.path(mapper), () -> ExpressionHelper.document(writer, "$not", () -> {
                        writer.writeName(this.getName());
                        this.writeUnnamedValue(this.getValue(mapper), mapper, writer, context);
                    }));
                } else {
                    this.writeNamedValue(this.path(mapper), this.getValue(mapper), mapper, writer, context);
                }
            }
        };
    }

    public static Filter exists(String field) {
        return new Filter("$exists", field, null){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                writer.writeStartDocument(this.path(mapper));
                writer.writeName(this.getName());
                writer.writeBoolean(!this.isNot());
                writer.writeEndDocument();
            }
        };
    }

    public static Filter expr(Expression expression) {
        return new Filter("$expr", null, expression){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                writer.writeName("$expr");
                Expression value = this.getValue();
                if (value != null) {
                    value.encode(mapper, writer, context);
                } else {
                    writer.writeNull();
                }
            }

            @Override
            public Expression getValue() {
                return (Expression)super.getValue();
            }
        };
    }

    public static Filter geoIntersects(String field, Geometry val) {
        return new GeoIntersectsFilter(field, val);
    }

    public static GeoWithinFilter geoWithin(String field, Polygon polygon) {
        return new GeoWithinFilter(field, polygon);
    }

    public static GeoWithinFilter geoWithin(String field, MultiPolygon polygon) {
        return new GeoWithinFilter(field, polygon);
    }

    public static Filter geometry(String field, Object val) {
        return new Filter("$geometry", field, val);
    }

    public static Filter gt(String field, Object val) {
        return new Filter("$gt", field, val);
    }

    public static Filter gte(String field, Object val) {
        return new Filter("$gte", field, val);
    }

    public static Filter in(String field, Iterable<?> val) {
        return new Filter("$in", field, val);
    }

    @Deprecated(forRemoval=true)
    public static Filter jsonSchema(String field, Object val) {
        return Filters.jsonSchema(Document.parse(val.toString()));
    }

    public static Filter jsonSchema(final Document schema) {
        return new Filter("$jsonSchema", null, schema){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                ExpressionHelper.value(mapper, writer, "$jsonSchema", schema, context);
            }
        };
    }

    public static Filter lt(String field, Object val) {
        return new Filter("$lt", field, val);
    }

    public static Filter lte(String field, Object val) {
        return new Filter("$lte", field, val);
    }

    public static Filter maxDistance(String field, Object val) {
        return new Filter("$maxDistance", field, val);
    }

    public static Filter minDistance(String field, Object val) {
        return new Filter("$minDistance", field, val);
    }

    public static Filter mod(String field, final long divisor, final long remainder) {
        return new Filter("$mod", field, null){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                writer.writeStartDocument(this.path(mapper));
                writer.writeName(this.getName());
                writer.writeStartArray();
                this.writeUnnamedValue(divisor, mapper, writer, context);
                this.writeUnnamedValue(remainder, mapper, writer, context);
                writer.writeEndArray();
                writer.writeEndDocument();
            }
        };
    }

    public static Filter ne(String field, Object val) {
        return new Filter("$ne", field, val);
    }

    public static NearFilter near(String field, Point point) {
        return new NearFilter("$near", field, point);
    }

    public static NearFilter nearSphere(String field, Point point) {
        return new NearFilter("$nearSphere", field, point);
    }

    public static Filter nin(String field, Object val) {
        return new Filter("$nin", field, val);
    }

    public static Filter nor(Filter ... filters) {
        return new LogicalFilter("$nor", filters);
    }

    public static Filter or(Filter ... filters) {
        return new LogicalFilter("$or", filters);
    }

    public static Filter polygon(String field, Point ... points) {
        return new PolygonFilter(field, points);
    }

    public static RegexFilter regex(String field) {
        return new RegexFilter(field);
    }

    public static Filter size(String field, int size) {
        return new Filter("$size", field, size);
    }

    public static TextSearchFilter text(String textSearch) {
        return new TextSearchFilter(textSearch);
    }

    public static Filter type(String field, Type val) {
        return new Filter("$type", field, val.toString().toLowerCase());
    }

    public static Filter uniqueDocs(String field, Object val) {
        return new Filter("$uniqueDocs", field, val);
    }

    public static Filter where(String val) {
        return new Filter("$where", null, val){

            @Override
            public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
                writer.writeName(this.getName());
                Object where = this.getValue(mapper);
                if (where != null) {
                    String value = where.toString().trim();
                    if (!value.startsWith("function()")) {
                        value = String.format("function() { %s }", value);
                    }
                    writer.writeString(value);
                } else {
                    writer.writeNull();
                }
            }
        };
    }
}

