/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import com.mongodb.client.model.geojson.Point;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class Box
extends Filter {
    private final Point bottomLeft;
    private final Point upperRight;

    protected Box(String field, Point bottomLeft, Point upperRight) {
        super("$box", field, null);
        this.bottomLeft = bottomLeft;
        this.upperRight = upperRight;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(mapper));
        writer.writeStartDocument("$geoWithin");
        writer.writeStartArray(this.getName());
        writer.writeStartArray();
        for (Double value : this.bottomLeft.getPosition().getValues()) {
            writer.writeDouble(value);
        }
        writer.writeEndArray();
        writer.writeStartArray();
        for (Double value : this.upperRight.getPosition().getValues()) {
            writer.writeDouble(value);
        }
        writer.writeEndArray();
        writer.writeEndArray();
        writer.writeEndDocument();
        writer.writeEndDocument();
    }
}

