/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.UpdateOptions;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.Query;
import dev.morphia.query.UpdateBase;
import dev.morphia.query.UpdateOpsImpl;
import dev.morphia.query.experimental.updates.UpdateOperator;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Update<T>
extends UpdateBase<T> {
    Update(Datastore datastore, Mapper mapper, MongoCollection<T> collection, Query<T> query, Class<T> type2, UpdateOpsImpl operations) {
        super(datastore, mapper, collection, query, type2, operations.getUpdates());
    }

    Update(Datastore datastore, Mapper mapper, MongoCollection<T> collection, Query<T> query, Class<T> type2, UpdateOperator first, UpdateOperator[] updates) {
        super(datastore, mapper, collection, query, type2, first, updates);
    }

    public UpdateResult execute() {
        return this.execute(new UpdateOptions());
    }

    public UpdateResult execute(UpdateOptions options) {
        Document updateOperations = this.toDocument();
        Document queryObject = this.getQuery().toDocument();
        ClientSession session = this.getDatastore().findSession(options);
        MongoCollection mongoCollection = options.prepare(this.getCollection());
        if (options.isMulti()) {
            return session == null ? mongoCollection.updateMany((Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options) : mongoCollection.updateMany(session, (Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
        }
        return session == null ? mongoCollection.updateOne((Bson)queryObject, (Bson)updateOperations, (com.mongodb.client.model.UpdateOptions)options) : mongoCollection.updateOne(session, (Bson)queryObject, updateOperations, (com.mongodb.client.model.UpdateOptions)options);
    }
}

