/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.query.OperationTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.bson.Document;

class Operations {
    private final Map<String, List<OperationTarget>> ops = new HashMap<String, List<OperationTarget>>();
    private final Mapper mapper;
    private final EntityModel entityModel;

    Operations(Mapper mapper, EntityModel model) {
        this.mapper = mapper;
        this.entityModel = model;
    }

    public String toString() {
        return new StringJoiner(", ", Operations.class.getSimpleName() + "[", "]").add("ops=" + this.ops).toString();
    }

    protected void versionUpdate() {
        PropertyModel versionField = this.entityModel.getVersionProperty();
        if (versionField != null) {
            boolean already;
            List<OperationTarget> operationTargets = this.ops.get("$inc");
            String version = versionField.getMappedName();
            boolean bl = already = operationTargets != null && operationTargets.stream().anyMatch(tv -> {
                PathTarget target = tv.getTarget();
                return target != null && target.translatedPath().equals(version);
            });
            if (!already) {
                this.add("$inc", new OperationTarget(new PathTarget(this.mapper, this.entityModel, versionField.getName()), 1L));
            }
        }
    }

    void add(String operator, OperationTarget value) {
        this.ops.computeIfAbsent(operator, o -> new ArrayList()).add(value);
    }

    Document toDocument() {
        this.versionUpdate();
        Document document = new Document();
        for (Map.Entry<String, List<OperationTarget>> entry : this.ops.entrySet()) {
            Document targets = new Document();
            for (OperationTarget operationTarget : entry.getValue()) {
                Object encode = operationTarget.encode(this.mapper);
                if (encode instanceof Document) {
                    targets.putAll((Document)encode);
                    continue;
                }
                document.put(entry.getKey(), encode);
            }
            if (targets.isEmpty()) continue;
            document.put(entry.getKey(), (Object)targets);
        }
        return document;
    }
}

