/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.lang.Nullable;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.LegacyQuery;
import java.util.StringJoiner;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

public class OperationTarget {
    private final PathTarget target;
    private final Object value;

    public OperationTarget(@Nullable PathTarget target, @Nullable Object value) {
        this.target = target;
        this.value = value;
    }

    public Object encode(Mapper mapper) {
        if (this.target == null) {
            if (this.value == null) {
                throw new NullPointerException();
            }
            return this.value;
        }
        PropertyModel mappedField = this.target.getTarget();
        Object mappedValue = this.value;
        PropertyModel model = mappedField != null ? mappedField.getEntityModel().getProperty(mappedField.getName()) : null;
        Codec<Object> cachedCodec = null;
        if (model != null && !(mappedValue instanceof LegacyQuery) && (cachedCodec = model.getCachedCodec()) == null) {
            cachedCodec = model.getCodec();
        }
        if (cachedCodec instanceof PropertyHandler) {
            mappedValue = ((PropertyHandler)((Object)cachedCodec)).encode(mappedValue);
        } else {
            DocumentWriter writer = new DocumentWriter(mapper);
            Object finalMappedValue = mappedValue;
            ExpressionHelper.document(writer, () -> ExpressionHelper.value(mapper, writer, "mapped", finalMappedValue, EncoderContext.builder().build()));
            mappedValue = writer.getDocument().get("mapped");
        }
        return new Document(this.target.translatedPath(), mappedValue);
    }

    @Nullable
    public PathTarget getTarget() {
        return this.target;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return new StringJoiner(", ", OperationTarget.class.getSimpleName() + "[", "]").add("target=" + this.target).add("value=" + this.value).toString();
    }
}

