/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.internal.MorphiaInternals;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.CountOptions;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Modify;
import dev.morphia.query.Query;
import dev.morphia.query.Shape;
import dev.morphia.query.Update;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.filters.NearFilter;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.internal.MorphiaKeyCursor;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MorphiaQuery<T>
implements Query<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MorphiaQuery.class);
    private final Datastore datastore;
    private final Class<T> type;
    private final Mapper mapper;
    private final String collectionName;
    private final MongoCollection<T> collection;
    private final List<Filter> filters = new ArrayList<Filter>();
    private final Document seedQuery;
    private boolean validate = true;

    protected MorphiaQuery(Datastore datastore, @Nullable String collectionName, Class<T> type2) {
        this.type = type2;
        this.datastore = datastore;
        this.mapper = this.datastore.getMapper();
        this.seedQuery = null;
        if (collectionName != null) {
            this.collection = datastore.getDatabase().getCollection(collectionName, type2);
            this.collectionName = collectionName;
        } else if (this.mapper.isMappable(type2)) {
            this.collection = this.mapper.getCollection(type2);
            this.collectionName = this.collection.getNamespace().getCollectionName();
        } else {
            this.collection = null;
            this.collectionName = null;
        }
    }

    protected MorphiaQuery(Datastore datastore, Class<T> type2, Document query) {
        this.type = type2;
        this.datastore = datastore;
        this.seedQuery = query;
        this.mapper = this.datastore.getMapper();
        this.collection = this.mapper.getCollection(type2);
        this.collectionName = this.collection.getNamespace().getCollectionName();
    }

    static <V> V legacyOperation() {
        throw new UnsupportedOperationException(Sofia.legacyOperation(new Locale[0]));
    }

    @Override
    public long count() {
        return this.count(new CountOptions());
    }

    @Override
    public long count(CountOptions options) {
        ClientSession session = this.datastore.findSession(options);
        Document query = this.getQueryDocument();
        return session == null ? this.getCollection().countDocuments(query, options) : this.getCollection().countDocuments(session, query, options);
    }

    @Override
    public DeleteResult delete(DeleteOptions options) {
        MongoCollection<T> collection = options.prepare(this.getCollection());
        ClientSession session = this.datastore.findSession(options);
        if (options.isMulti()) {
            return session == null ? collection.deleteMany(this.getQueryDocument(), options) : collection.deleteMany(session, this.getQueryDocument(), options);
        }
        return session == null ? collection.deleteOne(this.getQueryDocument(), options) : collection.deleteOne(session, this.getQueryDocument(), options);
    }

    @Override
    public Query<T> disableValidation() {
        this.validate = false;
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validate = true;
        return this;
    }

    @Override
    public Map<String, Object> explain(FindOptions options, @Nullable ExplainVerbosity verbosity) {
        return (Map)((Object)MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_2_0, () -> verbosity == null ? this.iterable(options, this.collection).explain() : this.iterable(options, this.collection).explain(verbosity), () -> new LinkedHashMap<String, Object>(this.datastore.getDatabase().runCommand(new Document("explain", new Document("find", this.getCollection().getNamespace().getCollectionName()).append("filter", this.getQueryDocument()))))));
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return new MorphiaQueryFieldEnd(name);
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        FilterOperator op = parts.length == 2 ? FilterOperator.fromString(parts[1]) : FilterOperator.EQUAL;
        return this.filter(op.apply(parts[0].trim(), value));
    }

    @Override
    public Query<T> filter(Filter ... additional) {
        for (Filter filter : additional) {
            this.filters.add(filter.entityType(this.getEntityClass()).isValidating(this.validate));
        }
        return this;
    }

    @Override
    public T findAndDelete(FindAndDeleteOptions options) {
        MongoCollection<T> mongoCollection = options.prepare(this.getCollection());
        ClientSession session = this.datastore.findSession(options);
        return session == null ? mongoCollection.findOneAndDelete(this.getQueryDocument(), options) : mongoCollection.findOneAndDelete(session, this.getQueryDocument(), options);
    }

    @Override
    public T first() {
        return this.first(new FindOptions());
    }

    @Override
    public T first(FindOptions options) {
        try (MorphiaCursor<T> it = this.iterator(options.copy().limit(1));){
            Object TResult = it.tryNext();
            return (T)TResult;
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.type;
    }

    @Override
    public MorphiaCursor<T> iterator(FindOptions options) {
        return new MorphiaCursor<T>(this.prepareCursor(options, this.getCollection()));
    }

    @Override
    public MorphiaKeyCursor<T> keys() {
        return this.keys(new FindOptions());
    }

    @Override
    public MorphiaKeyCursor<T> keys(FindOptions options) {
        FindOptions includeId = new FindOptions().copy(options).projection().include("_id");
        return new MorphiaKeyCursor<T>(this.prepareCursor(includeId, this.datastore.getDatabase().getCollection(this.getCollectionName())), this.datastore.getMapper(), this.type, this.getCollectionName());
    }

    @Override
    public Modify<T> modify(UpdateOperator first, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.mapper, this.getCollection(), this, this.getEntityClass(), first, updates);
    }

    @Override
    public Query<T> search(String searchText) {
        return this.filter(Filters.text(searchText));
    }

    @Override
    public Query<T> search(String searchText, String language) {
        return this.filter(Filters.text(searchText).language(language));
    }

    @Override
    public Document toDocument() {
        return this.getQueryDocument();
    }

    @Override
    public Update<T> update(UpdateOperator first, UpdateOperator ... updates) {
        return new Update<T>(this.datastore, this.mapper, this.getCollection(), this, this.type, first, updates);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.validate, this.getCollectionName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MorphiaQuery)) {
            return false;
        }
        MorphiaQuery query20 = (MorphiaQuery)o;
        return this.validate == query20.validate && Objects.equals(this.type, query20.type) && Objects.equals(this.getCollectionName(), query20.getCollectionName());
    }

    public String toString() {
        return new StringJoiner(", ", MorphiaQuery.class.getSimpleName() + "[", "]").add("clazz=" + this.type.getSimpleName()).add("query=" + this.getQueryDocument()).toString();
    }

    private MongoCollection<T> getCollection() {
        return this.collection;
    }

    private String getCollectionName() {
        return this.collectionName;
    }

    @NotNull
    private <E> FindIterable<E> iterable(FindOptions findOptions, MongoCollection<E> collection) {
        Document query = this.toDocument();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.getCollectionName(), query, findOptions));
        }
        if (findOptions.getCursorType() != null && findOptions.getCursorType() != CursorType.NonTailable && findOptions.getSort() != null) {
            LOG.warn("Sorting on tail is not allowed.");
        }
        ClientSession clientSession = this.datastore.findSession(findOptions);
        MongoCollection<E> updated = findOptions.prepare(collection);
        FindIterable<E> iterable = clientSession != null ? updated.find(clientSession, query) : updated.find(query);
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> MongoCursor<E> prepareCursor(FindOptions findOptions, MongoCollection<E> collection) {
        Document oldProfile = null;
        if (findOptions.isLogQuery()) {
            oldProfile = this.datastore.getDatabase().runCommand(new Document("profile", 2).append("slowms", 0));
        }
        try {
            Iterator iterator2 = findOptions.apply(this.iterable(findOptions, collection), this.mapper, this.type).iterator();
            return iterator2;
        }
        finally {
            if (findOptions.isLogQuery()) {
                this.datastore.getDatabase().runCommand(new Document("profile", oldProfile.get("was")).append("slowms", oldProfile.get("slowms")).append("sampleRate", oldProfile.get("sampleRate")));
            }
        }
    }

    Document getQueryDocument() {
        DocumentWriter writer = new DocumentWriter(this.mapper, this.seedQuery);
        ExpressionHelper.document(writer, () -> {
            EncoderContext context = EncoderContext.builder().build();
            for (Filter filter : this.filters) {
                filter.encode(this.mapper, writer, context);
            }
        });
        Document query = writer.getDocument();
        if (this.mapper.isMappable(this.getEntityClass())) {
            this.mapper.updateQueryWithDiscriminators(this.mapper.getEntityModel(this.getEntityClass()), query);
        }
        return query;
    }

    @Deprecated(since="2.0", forRemoval=true)
    private class MorphiaQueryFieldEnd
    extends FieldEndImpl {
        private final String name;

        private MorphiaQueryFieldEnd(String name) {
            super(MorphiaQuery.this.mapper, name, MorphiaQuery.this, MorphiaQuery.this.mapper.getEntityModel(MorphiaQuery.this.getEntityClass()), MorphiaQuery.this.validate);
            this.name = name;
        }

        @Override
        public CriteriaContainer within(Shape shape) {
            Filter converted;
            if (shape instanceof Shape.Center) {
                Shape.Center center = (Shape.Center)shape;
                converted = Filters.center(this.getField(), center.getCenter(), center.getRadius());
            } else if (shape.getGeometry().equals("$box")) {
                Point[] points = shape.getPoints();
                converted = Filters.box(this.getField(), points[0], points[1]);
            } else if (shape.getGeometry().equals("$polygon")) {
                converted = Filters.polygon(this.getField(), shape.getPoints());
            } else {
                throw new UnsupportedOperationException(Sofia.conversionNotSupported(shape.getGeometry(), new Locale[0]));
            }
            if (this.isNot()) {
                converted.not();
            }
            MorphiaQuery.this.filter(converted);
            return MorphiaQuery.this;
        }

        protected MorphiaQuery<T> addCriteria(FilterOperator op, Object val, boolean not) {
            Filter converted = op.apply(this.name, val);
            if (not) {
                converted.not();
            }
            MorphiaQuery.this.filter(converted);
            return MorphiaQuery.this;
        }

        protected CriteriaContainer addGeoCriteria(FilterOperator op, Object val, Map opts) {
            NearFilter apply2 = (NearFilter)op.apply(this.name, val);
            apply2.applyOpts(opts);
            MorphiaQuery.this.filter(apply2);
            return MorphiaQuery.this;
        }
    }
}

