/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.classrules;

import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import java.util.HashSet;
import java.util.Set;

public class DuplicatedAttributeNames
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, EntityModel entityModel, Set<ConstraintViolation> ve) {
        HashSet<String> foundNames = new HashSet<String>();
        for (PropertyModel model : entityModel.getProperties()) {
            for (String name : model.getLoadNames()) {
                if (foundNames.add(name)) continue;
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, entityModel, model, this.getClass(), "Mapping to MongoDB field name '" + name + "' is duplicated; you cannot map different java fields to the same MongoDB field."));
            }
        }
    }
}

