/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation;

import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ClassConstraint;

public class ConstraintViolation {
    private final EntityModel type;
    private final Class<? extends ClassConstraint> validator;
    private final String message;
    private final Level level;
    private PropertyModel property;

    public ConstraintViolation(Level level, EntityModel entityModel, PropertyModel property, Class<? extends ClassConstraint> validator, String message) {
        this(level, entityModel, validator, message);
        this.property = property;
    }

    public ConstraintViolation(Level level, EntityModel entityModel, Class<? extends ClassConstraint> validator, String message) {
        this.level = level;
        this.type = entityModel;
        this.message = message;
        this.validator = validator;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPrefix() {
        String fn = this.property != null ? this.property.getName() : "";
        return this.type.getType().getName() + "." + fn;
    }

    public String render() {
        return String.format("%s complained about %s : %s", this.validator.getSimpleName(), this.getPrefix(), this.message);
    }

    public static enum Level {
        MINOR,
        INFO,
        WARNING,
        SEVERE,
        FATAL;

    }
}

