/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.experimental.UnsafeAllocator;
import dev.morphia.sofia.Sofia;
import java.util.Locale;

public class UnsafeConstructorCreator
implements MorphiaInstanceCreator {
    private static final UnsafeAllocator UNSAFE_ALLOCATOR = UnsafeAllocator.create();
    private final Object instance;

    public UnsafeConstructorCreator(EntityModel model) {
        try {
            this.instance = UNSAFE_ALLOCATOR.newInstance(model.getType());
        }
        catch (Exception e) {
            throw new MappingException(Sofia.noSuitableConstructor(model.getType().getName(), new Locale[0]));
        }
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public void set(Object value, PropertyModel model) {
        model.getAccessor().set(this.instance, value);
    }
}

