/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.annotations.Handler;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.MorphiaReferenceCodec;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.mapping.experimental.SingleReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

@Handler(value=MorphiaReferenceCodec.class)
public abstract class MorphiaReference<T> {
    private Datastore datastore;
    private boolean ignoreMissing;
    private boolean resolved;

    MorphiaReference() {
    }

    MorphiaReference(Datastore datastore) {
        this.datastore = datastore;
    }

    public static <V> MorphiaReference<V> wrap(V value) {
        if (value instanceof List) {
            return new ListReference((List)value);
        }
        if (value instanceof Set) {
            return new SetReference((Set)value);
        }
        if (value instanceof Map) {
            return new MapReference((Map)value);
        }
        return new SingleReference<V>(value);
    }

    @Nullable
    public abstract T get();

    public abstract List<Object> getIds();

    public abstract Class<T> getType();

    public int hashCode() {
        return this.isResolved() ? 1 : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MorphiaReference)) {
            return false;
        }
        MorphiaReference that = (MorphiaReference)o;
        return this.getIds().equals(that.getIds());
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "<<", ">>").add(this.getIds().toString()).toString();
    }

    public MorphiaReference<T> ignoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
        return this;
    }

    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    protected void resolve() {
        this.resolved = true;
    }

    Datastore getDatastore() {
        return this.datastore;
    }

    abstract Object getId(Mapper var1, Datastore var2, EntityModel var3);
}

