/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBRef;
import dev.morphia.Datastore;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.references.ReferenceCodec;
import dev.morphia.mapping.experimental.CollectionReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.query.experimental.filters.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bson.Document;

public class MapReference<T>
extends MorphiaReference<Map<Object, T>> {
    private Map<String, Object> ids;
    private Map<Object, T> values;
    private final Map<String, List<Object>> collections = new HashMap<String, List<Object>>();

    public MapReference(Datastore datastore, Map<String, Object> ids, EntityModel entityModel) {
        super(datastore);
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            CollectionReference.collate(entityModel, this.collections, entry.getValue());
        }
        this.ids = ids;
    }

    private void setValues(Map<String, Object> values2) {
        this.resolve();
    }

    MapReference(Map<Object, T> values2) {
        this.values = values2;
    }

    public static MapReference decode(Datastore datastore, Mapper mapper, PropertyModel property, Document document) {
        Class<?> subType = property.getTypeData().getTypeParameters().get(0).getType();
        Map ids = (Map)property.getDocumentValue(document);
        MapReference reference = null;
        if (ids != null) {
            reference = new MapReference(datastore, ids, mapper.getEntityModel(subType));
        }
        return reference;
    }

    @Override
    public Map<Object, T> get() {
        if (this.values == null && this.ids != null) {
            this.values = new LinkedHashMap<Object, T>();
            this.mergeReads();
        }
        return this.values;
    }

    @Override
    public Class<Map<Object, T>> getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> getIds() {
        ArrayList<Object> ids = new ArrayList<Object>(this.ids.values());
        if (!ids.isEmpty() && ids.get(0) instanceof DBRef) {
            ListIterator<Object> iterator2 = ids.listIterator();
            while (iterator2.hasNext()) {
                iterator2.set(((DBRef)iterator2.next()).getId());
            }
        }
        return ids;
    }

    @Override
    public Map<String, Object> getId(Mapper mapper, Datastore datastore, EntityModel field) {
        if (this.ids == null) {
            this.ids = new LinkedHashMap<String, Object>();
            this.values.entrySet().stream().forEach(e -> this.ids.put(e.getKey().toString(), ReferenceCodec.encodeId(mapper, e.getValue(), field)));
        }
        return this.ids;
    }

    private void mergeReads() {
        for (Map.Entry<String, List<Object>> entry : this.collections.entrySet()) {
            this.readFromSingleCollection(entry.getKey(), entry.getValue());
        }
        this.resolve();
    }

    private void readFromSingleCollection(String collection, List<Object> collectionIds) {
        try (Iterator cursor = this.getDatastore().find(collection).filter(Filters.in("_id", collectionIds)).iterator();){
            HashMap idMap = new HashMap();
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                idMap.put(this.getDatastore().getMapper().getId(entity), entity);
            }
            for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
                Object id = entry.getValue();
                Object value = idMap.get(id instanceof DBRef ? ((DBRef)id).getId() : id);
                if (value == null) continue;
                this.values.put(entry.getKey(), value);
            }
        }
    }
}

