/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.Datastore;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.conventions.MorphiaConvention;

public class MorphiaDefaultsConvention
implements MorphiaConvention {
    @Override
    public void apply(Datastore datastore, EntityModelBuilder modelBuilder) {
        MapperOptions options = datastore.getMapper().getOptions();
        Entity entity = modelBuilder.getAnnotation(Entity.class);
        Embedded embedded = modelBuilder.getAnnotation(Embedded.class);
        if (entity != null) {
            modelBuilder.enableDiscriminator(entity.useDiscriminator());
            modelBuilder.discriminatorKey(this.applyDefaults(entity.discriminatorKey(), options.getDiscriminatorKey()));
        } else {
            modelBuilder.enableDiscriminator(embedded == null || embedded.useDiscriminator());
            modelBuilder.discriminatorKey(this.applyDefaults(embedded != null ? embedded.discriminatorKey() : ".", options.getDiscriminatorKey()));
        }
        options.getDiscriminator().apply(modelBuilder);
    }

    String applyDefaults(String configured, String defaultValue) {
        if (!configured.equals(".")) {
            return configured;
        }
        return defaultValue;
    }
}

