/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.Datastore;
import dev.morphia.mapping.codec.MethodAccessor;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MethodDiscovery
implements MorphiaConvention {
    private EntityModelBuilder entityModelBuilder;
    private Datastore datastore;

    @Override
    public void apply(Datastore datastore, EntityModelBuilder builder) {
        this.datastore = datastore;
        this.entityModelBuilder = builder;
        ArrayList list = new ArrayList(List.of(builder.getType()));
        list.addAll(builder.classHierarchy());
        for (Class clazz : list) {
            this.processMethods(clazz);
        }
    }

    private List<Annotation> discoverAnnotations(Method getter, Method setter) {
        return List.of(getter, setter).stream().flatMap(m3 -> Arrays.stream(m3.getDeclaredAnnotations())).collect(Collectors.toList());
    }

    private void processMethods(Class<?> type2) {
        Map<String, List<Method>> properties = Arrays.stream(type2.getDeclaredMethods()).filter(m3 -> m3.getName().startsWith("get") || m3.getName().startsWith("set") || m3.getName().startsWith("is")).collect(Collectors.groupingBy(m3 -> m3.getName().startsWith("get") || m3.getName().startsWith("set") ? this.stripPrefix((Method)m3, 3) : this.stripPrefix((Method)m3, 2)));
        for (Map.Entry<String, List<Method>> entry : properties.entrySet()) {
            List<Method> value = entry.getValue();
            if (value.size() != 2) continue;
            class Methods {
                private final Method getter;
                private final Method setter;

                Methods(List<Method> methods) {
                    List collect = methods.stream().sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
                    this.getter = (Method)collect.get(0);
                    this.setter = (Method)collect.get(1);
                }
            }
            Methods methods = new Methods(value);
            TypeData<?> typeData = this.entityModelBuilder.getTypeData(type2, TypeData.newInstance(methods.getter), methods.getter.getGenericReturnType());
            this.entityModelBuilder.addProperty().name(entry.getKey()).accessor(new MethodAccessor(methods.getter, methods.setter)).annotations(this.discoverAnnotations(methods.getter, methods.setter)).typeData(typeData).discoverMappedName(this.datastore.getMapper().getOptions());
        }
    }

    private String stripPrefix(Method method, int size) {
        Object name = method.getName().substring(size);
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return name;
    }
}

