/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.Datastore;
import dev.morphia.mapping.codec.ArrayFieldAccessor;
import dev.morphia.mapping.codec.FieldAccessor;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bson.codecs.pojo.PropertyAccessor;

public class FieldDiscovery
implements MorphiaConvention {
    @Override
    public void apply(Datastore datastore, EntityModelBuilder builder) {
        ArrayList list = new ArrayList(List.of(builder.getType()));
        list.addAll(builder.classHierarchy());
        for (Class clazz : list) {
            for (Field field : clazz.getDeclaredFields()) {
                TypeData<?> typeData = builder.getTypeData(clazz, TypeData.newInstance(field), field.getGenericType());
                builder.addProperty().name(field.getName()).typeData(typeData).annotations(List.of(field.getDeclaredAnnotations())).accessor(this.getAccessor(field, typeData)).modifiers(field.getModifiers()).discoverMappedName(datastore.getMapper().getOptions());
            }
        }
    }

    private PropertyAccessor<? super Object> getAccessor(Field field, TypeData<?> typeData) {
        return field.getType().isArray() && !field.getType().getComponentType().equals(Byte.TYPE) ? new ArrayFieldAccessor(typeData, field) : new FieldAccessor(field);
    }
}

