/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import dev.morphia.mapping.codec.writer.ArrayState;
import dev.morphia.mapping.codec.writer.DocumentState;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.bson.Document;

abstract class WriteState {
    private final DocumentWriter writer;
    private final WriteState previous;

    WriteState(DocumentWriter writer) {
        this.writer = writer;
        this.previous = writer.state(this);
    }

    protected abstract String state();

    protected String toString(Object value) {
        if (value instanceof Document) {
            StringJoiner joiner = new StringJoiner(", ", "{ ", " }");
            ((Document)value).entrySet().stream().map(e -> (String)e.getKey() + ": " + this.toString(e.getValue())).forEach(joiner::add);
            return joiner.toString();
        }
        if (value instanceof List) {
            StringJoiner joiner = new StringJoiner(", ", "[ ", " ]");
            ((List)value).stream().map(this::toString).forEach(joiner::add);
            return joiner.toString();
        }
        return String.valueOf(value);
    }

    WriteState array() {
        return new ArrayState(this.getWriter());
    }

    WriteState document() {
        return new DocumentState(this.getWriter());
    }

    final void end() {
        this.getWriter().previous();
    }

    DocumentWriter getWriter() {
        return this.writer;
    }

    WriteState name(String name) {
        throw new UnsupportedOperationException();
    }

    <P extends WriteState> P previous() {
        return (P)this.previous;
    }

    void value(Object value) {
        throw new IllegalStateException(Sofia.notInValidState("value", this.state(), new Locale[0]));
    }
}

