/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.writer.ArrayState;
import dev.morphia.mapping.codec.writer.DocumentState;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.codec.writer.WriteState;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

class NameState
extends WriteState {
    private final String name;
    private final Document document;
    private WriteState value;

    NameState(DocumentWriter writer, String name, Document document) {
        super(writer);
        this.name = name;
        if (!document.containsKey(name)) {
            this.document = document;
            document.put(name, (Object)this);
        } else {
            this.document = this.andTogether(document, name, this);
        }
    }

    private Document andTogether(Document doc, String key, @Nullable Object additional) {
        if (additional != null) {
            Document newSubdoc = new Document(key, additional);
            Object extant = doc.remove(key);
            ArrayList<Document> and = (ArrayList<Document>)doc.get("$and");
            if (and != null) {
                and.add(newSubdoc);
            } else {
                and = new ArrayList<Document>();
                and.addAll(List.of(new Document(key, extant), newSubdoc));
                doc.put("$and", (Object)and);
                return newSubdoc;
            }
        }
        return doc;
    }

    public String toString() {
        return this.value == null ? "<<pending>>" : this.value.toString();
    }

    @Override
    protected String state() {
        return "name";
    }

    @Override
    WriteState array() {
        this.value = new ArrayState(this.getWriter());
        this.document.put(this.name, (Object)((ArrayState)this.value).getList());
        return this.value;
    }

    @Override
    WriteState document() {
        if (this.document.get(this.name) instanceof Document) {
            this.value = new DocumentState(this.getWriter(), (Document)this.document.get(this.name));
        } else {
            this.value = new DocumentState(this.getWriter());
            this.document.put(this.name, (Object)((DocumentState)this.value).getDocument());
        }
        return this.value;
    }

    DocumentState previous() {
        return (DocumentState)super.previous();
    }

    @Override
    void value(Object value) {
        this.document.put(this.name, value);
        this.end();
    }
}

