/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.codec.writer.NameState;
import dev.morphia.mapping.codec.writer.WriteState;
import org.bson.Document;

class DocumentState
extends WriteState {
    private final Document document;

    DocumentState(DocumentWriter writer) {
        super(writer);
        this.document = new Document();
    }

    DocumentState(DocumentWriter writer, Document seed) {
        super(writer);
        this.document = seed != null ? seed : new Document();
    }

    public DocumentState applyValue(String name, Object value) {
        if (value instanceof Document && this.document.get(name) instanceof Document) {
            Document extant = (Document)this.document.get(name);
            extant.putAll((Document)value);
        } else {
            this.document.put(name, value);
        }
        this.getWriter().state(this);
        return this;
    }

    public String toString() {
        return this.toString(this.document);
    }

    @Override
    protected String state() {
        return "name";
    }

    @Override
    NameState name(String name) {
        return new NameState(this.getWriter(), name, this.document);
    }

    Document getDocument() {
        return this.document;
    }
}

