/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.reader;

import dev.morphia.mapping.codec.reader.DocumentEndState;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.reader.NameState;
import dev.morphia.mapping.codec.reader.ReaderState;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonType;
import org.bson.Document;

class DocumentState
extends ReaderState {
    public static final String NAME = "DOCUMENT";
    private final Document document;
    private DocumentEndState endState;

    DocumentState(DocumentReader reader, Document document) {
        super(reader);
        this.document = document;
    }

    @Override
    void skipValue() {
        this.reader().state(this.endState != null ? this.endState.nextState() : this.nextState());
    }

    @Override
    BsonType getCurrentBsonType() {
        return BsonType.DOCUMENT;
    }

    @Override
    String getStateName() {
        return NAME;
    }

    @Override
    void startDocument() {
        if (this.endState == null) {
            List states = this.document.entrySet().stream().flatMap(e -> {
                List<ReaderState> nameStates = List.of(new NameState(this.reader(), (String)e.getKey()), this.valueState(e.getValue()));
                return nameStates.stream();
            }).collect(Collectors.toList());
            ReaderState docState = null;
            for (ReaderState state : states) {
                if (docState != null) {
                    docState.next(state);
                } else {
                    this.next(state);
                }
                docState = state;
            }
            this.endState = new DocumentEndState(this.reader());
            if (docState != null) {
                docState.next(this.endState);
            } else {
                this.next(this.endState);
            }
        }
        this.advance();
    }
}

