/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.mapping.codec.pojo.WildCardTypeData;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.TypeWithTypeParameters;

public class TypeData<T>
implements TypeWithTypeParameters<T> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASS_MAP = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);
    private final Class<T> type;
    private final List<TypeData<?>> typeParameters;

    TypeData(Class<T> type2, List<TypeData<?>> typeParameters) {
        this.type = this.boxType(type2);
        this.typeParameters = typeParameters;
    }

    public static <T> Builder<T> builder(Class<T> type2) {
        return new Builder<T>(Assertions.notNull("type", type2));
    }

    private static <T> TypeData<?> getTypeData(Type type2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type2;
            Builder<T> paramBuilder = TypeData.builder((Class)pType.getRawType());
            for (Type argType : pType.getActualTypeArguments()) {
                paramBuilder.addTypeParameter(TypeData.getTypeData(argType));
            }
            return paramBuilder.build();
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type[] upperBounds = wildcardType.getUpperBounds();
            Type[] bounds = upperBounds != null ? upperBounds : wildcardType.getLowerBounds();
            WildCardTypeData.Builder wildCard = WildCardTypeData.builder(upperBounds != null);
            for (Type bound : bounds) {
                wildCard.addTypeParameter(TypeData.getTypeData(bound));
            }
            return wildCard.build();
        }
        if (type2 instanceof TypeVariable) {
            return TypeData.builder(Object.class).build();
        }
        if (type2 instanceof Class) {
            Builder<T> builder = TypeData.builder((Class)type2);
            for (TypeVariable typeParameter : builder.type.getTypeParameters()) {
                builder.addTypeParameter(TypeData.getTypeData(typeParameter));
            }
            return builder.build();
        }
        throw new UnsupportedOperationException(Sofia.unhandledTypeData(type2.getTypeName(), new Locale[0]));
    }

    private static String nestedTypeParameters(List<TypeData<?>> typeParameters) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int last = typeParameters.size();
        for (TypeData<?> typeParameter : typeParameters) {
            ++count;
            builder.append(typeParameter.getType().getSimpleName());
            if (!typeParameter.getTypeParameters().isEmpty()) {
                builder.append(String.format("<%s>", TypeData.nestedTypeParameters(typeParameter.getTypeParameters())));
            }
            if (count >= last) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static TypeData<?> newInstance(Field field) {
        return TypeData.newInstance(field.getGenericType(), field.getType());
    }

    public static TypeData<?> newInstance(Method method) {
        return TypeData.newInstance(method.getGenericReturnType(), method.getReturnType());
    }

    public static <T> TypeData<T> newInstance(Type genericType, Class<T> clazz) {
        Builder<T> builder = TypeData.builder(clazz);
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            for (Type argType : pType.getActualTypeArguments()) {
                builder.addTypeParameter(TypeData.getTypeData(argType));
            }
        }
        return builder.build();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public List<TypeData<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getTypeParameters().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeData)) {
            return false;
        }
        TypeData that = (TypeData)o;
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public String toString() {
        String typeParams = this.typeParameters.isEmpty() ? "" : ", typeParameters=[" + TypeData.nestedTypeParameters(this.typeParameters) + "]";
        return "TypeData{type=" + this.type.getSimpleName() + typeParams + "}";
    }

    public TypeData<?> withType(Class<?> concreteClass) {
        return new TypeData(concreteClass, new ArrayList(this.typeParameters));
    }

    private <S> Class<S> boxType(Class<S> clazz) {
        if (clazz.isPrimitive()) {
            return PRIMITIVE_CLASS_MAP.get(clazz);
        }
        return clazz;
    }

    boolean isAssignableFrom(Class<?> cls) {
        return this.type.isAssignableFrom(this.boxType(cls));
    }

    public static final class Builder<T> {
        private final Class<T> type;
        private final List<TypeData<?>> typeParameters = new ArrayList();

        private Builder(Class<T> type2) {
            this.type = type2;
        }

        public <S> Builder<T> addTypeParameter(TypeData<S> typeParameter) {
            this.typeParameters.add(Assertions.notNull("typeParameter", typeParameter));
            return this;
        }

        public TypeData<T> build() {
            return new TypeData<T>(this.type, Collections.unmodifiableList(this.typeParameters));
        }
    }
}

