/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.Datastore;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.PropertyCodecRegistryImpl;
import dev.morphia.mapping.codec.pojo.EntityDecoder;
import dev.morphia.mapping.codec.pojo.EntityEncoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.types.ObjectId;

public class MorphiaCodec<T>
implements CollectibleCodec<T> {
    private final PropertyModel idProperty;
    private final Mapper mapper;
    private final EntityModel entityModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final DiscriminatorLookup discriminatorLookup;
    private EntityEncoder encoder;
    private EntityDecoder decoder;

    public MorphiaCodec(Datastore datastore, EntityModel model, List<PropertyCodecProvider> propertyCodecProviders, DiscriminatorLookup discriminatorLookup, CodecRegistry registry) {
        this.mapper = datastore.getMapper();
        this.discriminatorLookup = discriminatorLookup;
        this.entityModel = model;
        this.registry = CodecRegistries.fromRegistries(CodecRegistries.fromCodecs(this), registry);
        this.propertyCodecRegistry = new PropertyCodecRegistryImpl(this, registry, propertyCodecProviders);
        this.idProperty = model.getIdProperty();
        this.specializePropertyCodecs();
        this.encoder = new EntityEncoder(this);
        this.decoder = new EntityDecoder(this);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return (T)this.getDecoder().decode(reader, decoderContext);
    }

    @Override
    public boolean documentHasId(Object entity) {
        PropertyModel idField = this.entityModel.getIdProperty();
        if (idField == null) {
            throw new MappingException(Sofia.idRequired(entity.getClass().getName(), new Locale[0]));
        }
        return idField.getValue(entity) != null;
    }

    public EntityModel getEntityModel() {
        return this.entityModel;
    }

    public EntityEncoder getEncoder() {
        return this.encoder;
    }

    public MorphiaCodec<T> setEncoder(EntityEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    protected EntityDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(EntityDecoder decoder2) {
        this.decoder = decoder2;
    }

    @Override
    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        this.encoder.encode(writer, value, encoderContext);
    }

    @Override
    public Class getEncoderClass() {
        return this.getEntityModel().getType();
    }

    @Override
    public Object generateIdIfAbsentFromDocument(Object entity) {
        if (!this.documentHasId(entity)) {
            this.idProperty.setValue(entity, Conversions.convert(new ObjectId(), this.idProperty.getType()));
        }
        return entity;
    }

    @Override
    public BsonValue getDocumentId(Object document) {
        throw new UnsupportedOperationException();
    }

    private void specializePropertyCodecs() {
        EntityModel entityModel = this.getEntityModel();
        for (PropertyModel propertyModel : entityModel.getProperties()) {
            Codec<?> codec = propertyModel.getCodec() != null ? propertyModel.getCodec() : this.propertyCodecRegistry.get(propertyModel.getTypeData());
            if (codec == null) continue;
            propertyModel.cachedCodec(codec);
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }

    CodecRegistry getRegistry() {
        return this.registry;
    }
}

