/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

public class EntityDecoder
implements Decoder<Object> {
    private final MorphiaCodec<?> morphiaCodec;
    private final EntityModel classModel;

    protected EntityDecoder(MorphiaCodec<?> morphiaCodec) {
        this.morphiaCodec = morphiaCodec;
        this.classModel = morphiaCodec.getEntityModel();
    }

    @Override
    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        if (decoderContext.hasCheckedDiscriminator()) {
            MorphiaInstanceCreator instanceCreator = this.getInstanceCreator();
            this.decodeProperties(reader, decoderContext, instanceCreator, this.classModel);
            return instanceCreator.getInstance();
        }
        Object entity = this.getCodecFromDocument(reader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.morphiaCodec.getRegistry(), this.morphiaCodec.getDiscriminatorLookup(), this.morphiaCodec).decode(reader, DecoderContext.builder().checkedDiscriminator(true).build());
        return entity;
    }

    protected MorphiaInstanceCreator getInstanceCreator() {
        return this.classModel.getInstanceCreator();
    }

    protected void decodeModel(BsonReader reader, DecoderContext decoderContext, MorphiaInstanceCreator instanceCreator, @Nullable PropertyModel model) {
        block5: {
            if (model != null) {
                BsonReaderMark mark = reader.getMark();
                try {
                    if (reader.getCurrentBsonType() == BsonType.NULL) {
                        reader.readNull();
                        break block5;
                    }
                    Object value = decoderContext.decodeWithChildContext(model.getCachedCodec(), reader);
                    instanceCreator.set(value, model);
                }
                catch (BsonInvalidOperationException e) {
                    mark.reset();
                    Object value = this.morphiaCodec.getMapper().getCodecRegistry().get(Object.class).decode(reader, decoderContext);
                    instanceCreator.set(Conversions.convert(value, model.getTypeData().getType()), model);
                }
            } else {
                reader.skipValue();
            }
        }
    }

    protected void decodeProperties(BsonReader reader, DecoderContext decoderContext, MorphiaInstanceCreator instanceCreator, EntityModel classModel) {
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String name = reader.readName();
            if (classModel.useDiscriminator() && classModel.getDiscriminatorKey().equals(name)) {
                reader.readString();
                continue;
            }
            this.decodeModel(reader, decoderContext, instanceCreator, classModel.getProperty(name));
        }
        reader.readEndDocument();
    }

    protected Codec<?> getCodecFromDocument(BsonReader reader, boolean useDiscriminator, String discriminatorKey, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, Codec<?> defaultCodec) {
        Codec<?> codec = null;
        if (useDiscriminator) {
            BsonReaderMark mark = reader.getMark();
            try {
                reader.readStartDocument();
                while (codec == null && reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    if (discriminatorKey.equals(reader.readName())) {
                        codec = registry.get(discriminatorLookup.lookup(reader.readString()));
                        continue;
                    }
                    reader.skipValue();
                }
            }
            catch (Exception e) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding errored with: %s", this.morphiaCodec.getEntityModel().getName(), e.getMessage()), e);
            }
            finally {
                mark.reset();
            }
        }
        return codec != null ? codec : defaultCodec;
    }

    protected MorphiaCodec<?> getMorphiaCodec() {
        return this.morphiaCodec;
    }
}

