/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.mapping.MappingException;
import dev.morphia.sofia.Sofia;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.bson.Document;

public class ClassMethodPair {
    private final Class<?> type;
    private final Method method;
    private final Datastore datastore;
    private final Class<? extends Annotation> event;

    ClassMethodPair(Datastore datastore, Method method, @Nullable Class<?> type2, Class<? extends Annotation> event) {
        this.event = event;
        this.type = type2;
        this.method = method;
        this.datastore = datastore;
    }

    void invoke(Document document, Object entity) {
        try {
            Object instance = this.type != null ? this.getOrCreateInstance(this.type) : entity;
            Method method = this.getMethod();
            method.setAccessible(true);
            Sofia.logCallingLifecycleMethod(this.event.getSimpleName(), method, instance, new Locale[0]);
            ArrayList<Object> args2 = new ArrayList<Object>();
            for (Class<?> parameterType : method.getParameterTypes()) {
                if (parameterType.equals(Document.class)) {
                    args2.add(document);
                    continue;
                }
                if (parameterType.equals(Datastore.class)) {
                    args2.add(this.datastore);
                    continue;
                }
                args2.add(entity);
            }
            method.invoke(instance, args2.toArray());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Object getOrCreateInstance(Class<?> type2) {
        try {
            Constructor<?> declaredConstructor = type2.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(Sofia.cannotInstantiate(type2, e.getMessage(), new Locale[0]));
        }
    }

    public Method getMethod() {
        return this.method;
    }
}

